/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication.file;

import java.util.List;
import java.util.Objects;
import org.eclipse.hono.authentication.file.FileBasedAuthenticationServiceOptions;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.SignatureSupportingConfigProperties;

public class FileBasedAuthenticationServiceConfigProperties {
    private String permissionsPath = null;
    private SignatureSupportingConfigProperties signingProps = new SignatureSupportingConfigProperties();
    private List<String> supportedSaslMechanisms = List.of("EXTERNAL", "PLAIN");

    public FileBasedAuthenticationServiceConfigProperties() {
    }

    public FileBasedAuthenticationServiceConfigProperties(FileBasedAuthenticationServiceOptions options) {
        this.signingProps = new SignatureSupportingConfigProperties(options.signing());
        this.permissionsPath = options.permissionsPath();
        this.supportedSaslMechanisms = options.supportedSaslMechanisms();
    }

    public final SignatureSupportingConfigProperties getSigning() {
        return this.signingProps;
    }

    public final SignatureSupportingConfigProperties getValidation() {
        return this.getSigning();
    }

    public final String getPermissionsPath() {
        return this.permissionsPath;
    }

    public final void setPermissionsPath(String permissionsPath) {
        this.permissionsPath = Objects.requireNonNull(permissionsPath);
    }

    public final List<String> getSupportedSaslMechanisms() {
        return this.supportedSaslMechanisms;
    }

    public final void setSupportedSaslMechanisms(List<String> supportedSaslMechanisms) {
        if (Objects.requireNonNull(supportedSaslMechanisms).stream().noneMatch(AbstractHonoAuthenticationService::isCompatibleSaslMechanism)) {
            throw new IllegalArgumentException("invalid list of SASL mechanisms");
        }
        this.supportedSaslMechanisms = supportedSaslMechanisms;
    }
}

