/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication;

import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.security.JwkSet;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;
import org.eclipse.hono.service.auth.AuthTokenFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/validating-keys")
public final class JwkResource {
    private static final Logger LOG = LoggerFactory.getLogger(JwkResource.class);
    private final Buffer jwkBytes;

    public JwkResource(AuthTokenFactory authTokenFactory) {
        Objects.requireNonNull(authTokenFactory);
        JwkSet jwkSet = authTokenFactory.getValidatingJwkSet();
        this.jwkBytes = Buffer.buffer((byte[])new JacksonSerializer().serialize((Object)jwkSet));
        if (LOG.isInfoEnabled()) {
            LOG.info("using JWK set:{}{}", (Object)System.lineSeparator(), (Object)new JsonObject(this.jwkBytes).encodePrettily());
        }
    }

    @GET
    @Produces(value={"application/jwk-set+json"})
    public Buffer getJwk() {
        LOG.debug("serving JWK set for validating JWTs");
        return this.jwkBytes;
    }
}

