/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.authentication;

import io.vertx.core.Vertx;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.service.amqp.AbstractAmqpEndpoint;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;

public class AuthenticationEndpoint
extends AbstractAmqpEndpoint<Object> {
    public AuthenticationEndpoint(Vertx vertx) {
        super(vertx);
    }

    public final String getName() {
        return "cbs";
    }

    public final void onLinkAttach(ProtonConnection con, ProtonSender sender, ResourceIdentifier targetResource) {
        if (ProtonQoS.AT_LEAST_ONCE.equals((Object)sender.getRemoteQoS())) {
            HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
            ((ProtonSender)sender.setQoS(ProtonQoS.AT_LEAST_ONCE)).open();
            this.logger.debug("transferring token to client...");
            Message tokenMsg = ProtonHelper.message((String)user.getToken());
            MessageHelper.addProperty((Message)tokenMsg, (String)"type", (Object)"amqp:jwt");
            sender.send(tokenMsg, disposition -> {
                if (disposition.remotelySettled()) {
                    this.logger.debug("successfully transferred auth token to client");
                } else {
                    this.logger.debug("failed to transfer auth token to client");
                }
                sender.close();
            });
        } else {
            this.onLinkDetach((ProtonLink)sender, ProtonHelper.condition((Symbol)AmqpError.INVALID_FIELD, (String)"supports AT_LEAST_ONCE delivery mode only"));
        }
    }

    public final void onLinkAttach(ProtonConnection con, ProtonReceiver receiver, ResourceIdentifier targetResource) {
        super.onLinkAttach(con, receiver, targetResource);
    }

    public void onConnectionClosed(ProtonConnection connection) {
    }
}

