/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.vertx.example.base;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import java.util.concurrent.CountDownLatch;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.MessageHelper;

public class HonoConsumerBase {
    public static final String HONO_CLIENT_USER = "consumer@HONO";
    public static final String HONO_CLIENT_PASSWORD = "verysecret";
    private final Vertx vertx = Vertx.vertx();
    private final HonoClient honoClient;
    private boolean eventMode = false;

    public HonoConsumerBase() {
        ClientConfigProperties props = new ClientConfigProperties();
        props.setHost("127.0.0.1");
        props.setPort(15671);
        props.setUsername(HONO_CLIENT_USER);
        props.setPassword(HONO_CLIENT_PASSWORD);
        props.setTrustStorePath("target/config/hono-demo-certs-jar/trusted-certs.pem");
        props.setHostnameVerificationRequired(false);
        this.honoClient = new HonoClientImpl(this.vertx, props);
    }

    protected void consumeData() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Future consumerFuture = Future.future();
        consumerFuture.setHandler(result -> {
            if (!result.succeeded()) {
                System.err.println("honoClient could not create telemetry consumer for 127.0.0.1:15671 : " + result.cause());
            }
            latch.countDown();
        });
        this.honoClient.connect(new ProtonClientOptions()).compose(connectedClient -> {
            if (this.eventMode) {
                return connectedClient.createEventConsumer("DEFAULT_TENANT", this::handleMessage, closeHook -> System.err.println("remotely detached consumer link"));
            }
            return connectedClient.createTelemetryConsumer("DEFAULT_TENANT", this::handleMessage, closeHook -> System.err.println("remotely detached consumer link"));
        }).setHandler(consumerFuture.completer());
        latch.await();
        if (consumerFuture.succeeded()) {
            System.in.read();
        }
        this.vertx.close();
    }

    private void handleMessage(Message msg) {
        Section body = msg.getBody();
        if (!(body instanceof Data)) {
            return;
        }
        String content = ((Data)msg.getBody()).getValue().toString();
        String deviceId = MessageHelper.getDeviceId((Message)msg);
        StringBuilder sb = new StringBuilder("received message [device: ").append(deviceId).append(", content-type: ").append(msg.getContentType()).append(" ]: ").append(content);
        if (msg.getApplicationProperties() != null) {
            sb.append(" with application properties: ").append(msg.getApplicationProperties().getValue());
        }
        System.out.println(sb.toString());
    }

    public boolean isEventMode() {
        return this.eventMode;
    }

    public void setEventMode(boolean value) {
        this.eventMode = value;
    }
}

