/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.eclipse.hono.client.RegistrationClient;
import org.eclipse.hono.example.AbstractExampleClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"sender"})
public class ExampleSender
extends AbstractExampleClient {
    @Value(value="${device.id}")
    private String deviceId;
    private String token;

    @PostConstruct
    public void prepare() {
        this.LOG.info("starting sender");
        CountDownLatch startup = new CountDownLatch(1);
        this.ctx = this.vertx.getOrCreateContext();
        Future startupTracker = Future.future();
        startupTracker.setHandler(done -> {
            if (done.succeeded()) {
                startup.countDown();
            } else {
                this.LOG.error("Error occurred during initialization: {}", (Object)done.cause().getMessage());
            }
        });
        this.ctx.runOnContext(go -> {
            Future connectionTracker = Future.future();
            this.client.connect(this.getClientOptions(), connectionTracker.completer());
            connectionTracker.compose(v -> this.getRegistrationClient()).compose(regClient -> {
                Future regResultTracker = Future.future();
                regClient.register(this.deviceId, null, regResultTracker.completer());
                return regResultTracker;
            }).compose(regResult -> {
                if (regResult.getStatus() == 201 || regResult.getStatus() == 409) {
                    this.LOG.info("device registered");
                    startupTracker.complete();
                } else {
                    startupTracker.fail(String.format("Failed to register device [%s]: %s", this.deviceId, regResult));
                }
            }, startupTracker);
        });
        try {
            if (!startup.await(5L, TimeUnit.SECONDS)) {
                this.LOG.error("shutting down");
                this.vertx.close();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @EventListener(classes={ApplicationReadyEvent.class})
    public void readMessagesFromStdin() {
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                String input;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ExampleSender.this.LOG.info("sender for tenant [{}] created successfully", (Object)ExampleSender.this.tenantId);
                ExampleSender.this.LOG.info("Enter some message(s) (hit return to send, ctrl-c to quit)");
                Scanner scanner = new Scanner(System.in);
                do {
                    String msg;
                    if ((msg = (input = scanner.nextLine())).isEmpty()) continue;
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("my_prop_string", "I'm a string");
                    properties.put("my_prop_int", 10);
                    CountDownLatch latch = new CountDownLatch(1);
                    Future sendTracker = Future.future();
                    sendTracker.setHandler(s -> {
                        if (s.failed()) {
                            ExampleSender.this.LOG.info(s.cause().getMessage());
                        }
                    });
                    ExampleSender.this.getRegistrationAssertion().compose(token -> ExampleSender.this.send(msg, properties, token)).compose(sent -> {
                        latch.countDown();
                        sendTracker.complete();
                    }, sendTracker);
                    try {
                        if (latch.await(2L, TimeUnit.SECONDS)) continue;
                        sendTracker.fail("cannot connect to server");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!input.isEmpty());
                scanner.close();
            }
        };
        new Thread(reader).start();
    }

    private Future<String> getRegistrationAssertion() {
        Future result = Future.future();
        if (this.token != null) {
            // empty if block
        }
        this.getRegistrationClient().compose(regClient -> {
            Future tokenTracker = Future.future();
            regClient.assertRegistration(this.deviceId, tokenTracker.completer());
            return tokenTracker;
        }).compose(regResult -> {
            if (regResult.getStatus() == 200) {
                result.complete((Object)((JsonObject)regResult.getPayload()).getString("assertion"));
            } else {
                result.fail("cannot assert registration status");
            }
        }, result);
        return result;
    }

    private Future<RegistrationClient> getRegistrationClient() {
        Future result = Future.future();
        this.client.getOrCreateRegistrationClient(this.tenantId, result.completer());
        return result;
    }

    private Future<Void> send(String msg, Map<String, Object> props, String registrationAssertion) {
        Future result = Future.future();
        Future senderTracker = Future.future();
        if (this.activeProfiles.contains("event")) {
            this.client.getOrCreateEventSender(this.tenantId, senderTracker.completer());
        } else {
            this.client.getOrCreateTelemetrySender(this.tenantId, senderTracker.completer());
        }
        senderTracker.compose(sender -> {
            if (!sender.send(this.deviceId, props, msg, "text/plain", registrationAssertion)) {
                this.LOG.info("sender has no credit (yet), maybe no consumers attached? Try again ...");
            }
            result.complete();
        }, result);
        return result;
    }
}

