/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.example;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClientOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.HonoClientConfigProperties;
import org.eclipse.hono.client.TelemetrySender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"sender"})
public class ExampleSender {
    private static final Logger LOG = LoggerFactory.getLogger(ExampleSender.class);
    @Value(value="${tenant.id}")
    private String tenantId;
    @Value(value="${device.id}")
    private String deviceId;
    @Autowired
    private HonoClientConfigProperties clientConfig;
    @Autowired
    private Vertx vertx;
    private Context ctx;
    private HonoClient client;

    @PostConstruct
    private void start() {
        this.client = HonoClient.HonoClientBuilder.newClient((HonoClientConfigProperties)this.clientConfig).vertx(this.vertx).build();
        this.ctx = this.vertx.getOrCreateContext();
        Future startupTracker = Future.future();
        startupTracker.setHandler(done -> {
            if (done.succeeded()) {
                this.vertx.executeBlocking(f -> this.readMessagesFromStdin((TelemetrySender)done.result(), f), false, exit -> this.vertx.close());
            } else {
                LOG.error("Error occurred during initialization: {}", (Object)done.cause().getMessage());
                this.vertx.close();
            }
        });
        this.ctx.runOnContext(go -> {
            Future connectionTracker = Future.future();
            this.client.connect(new ProtonClientOptions(), connectionTracker.completer());
            connectionTracker.compose(v -> {
                Future regClientTracker = Future.future();
                this.client.createRegistrationClient(this.tenantId, regClientTracker.completer());
                return regClientTracker;
            }).compose(regClient -> {
                Future regResultTracker = Future.future();
                regClient.register(this.deviceId, null, regResultTracker.completer());
                return regResultTracker;
            }).compose(regResult -> {
                Future resultCodeTracker = Future.future();
                if (regResult.getStatus() == 201) {
                    LOG.info("Device registered successfully.");
                    resultCodeTracker.complete();
                } else if (regResult.getStatus() == 409) {
                    LOG.info("Device already registered.");
                    resultCodeTracker.complete();
                } else {
                    resultCodeTracker.fail(String.format("Failed to register device [%s]: %s", this.deviceId, regResult));
                }
                return resultCodeTracker;
            }).compose(v -> this.client.createTelemetrySender(this.tenantId, startupTracker.completer()), startupTracker);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessagesFromStdin(TelemetrySender telemetryClient, Future<Object> f) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String input;
            do {
                LOG.info("Enter some message to send (empty message to quit): ");
                input = reader.readLine();
                if (input.isEmpty()) continue;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("my_prop_string", "I'm a string");
                properties.put("my_prop_int", 10);
                telemetryClient.send(this.deviceId, properties, input, "text/plain");
            } while (!input.isEmpty());
            f.complete();
        }
        catch (IOException e) {
            LOG.error("problem reading message from STDIN", (Throwable)e);
            f.fail((Throwable)e);
        }
        finally {
            this.client.shutdown();
        }
    }
}

