/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.telemetry.kafka;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.producer.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.MessagingKafkaProducerConfigProperties;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.kafka.AbstractKafkaBasedDownstreamSender;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;

public class KafkaBasedEventSender
extends AbstractKafkaBasedDownstreamSender
implements EventSender {
    public KafkaBasedEventSender(Vertx vertx, KafkaProducerFactory<String, Buffer> producerFactory, MessagingKafkaProducerConfigProperties kafkaProducerConfig, boolean includeDefaults, Tracer tracer) {
        super(vertx, producerFactory, "event", kafkaProducerConfig, includeDefaults, tracer);
    }

    @Override
    protected HonoTopic.Type getTopicType() {
        return HonoTopic.Type.EVENT;
    }

    public Future<Void> sendEvent(TenantObject tenant, RegistrationAssertion device, String contentType, Buffer payload, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        if (this.log.isTraceEnabled()) {
            this.log.trace("sending event [tenantId: {}, deviceId: {}, contentType: {}, properties: {}]", new Object[]{tenant.getTenantId(), device.getDeviceId(), contentType, properties});
        }
        HonoTopic topic = new HonoTopic(HonoTopic.Type.EVENT, tenant.getTenantId());
        Map<String, Object> propsWithDefaults = this.addDefaults(topic.getType().endpoint, tenant, device, QoS.AT_LEAST_ONCE, contentType, payload, properties);
        String topicName = topic.toString();
        Span currentSpan = this.startChildSpan("forward Event", topicName, tenant.getTenantId(), device.getDeviceId(), context);
        return this.sendAndWaitForOutcome(topic.toString(), tenant.getTenantId(), device.getDeviceId(), payload, propsWithDefaults, currentSpan).onComplete(ar -> currentSpan.finish());
    }

    public String toString() {
        return KafkaBasedEventSender.class.getName() + " via Kafka";
    }
}

