/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.telemetry.kafka;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.KafkaProducerFactory;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.kafka.AbstractKafkaBasedDownstreamSender;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;

public class KafkaBasedEventSender
extends AbstractKafkaBasedDownstreamSender
implements EventSender {
    public KafkaBasedEventSender(KafkaProducerFactory<String, Buffer> producerFactory, KafkaProducerConfigProperties kafkaProducerConfig, boolean includeDefaults, Tracer tracer) {
        super(producerFactory, "event", kafkaProducerConfig, includeDefaults, tracer);
    }

    public Future<Void> sendEvent(TenantObject tenant, RegistrationAssertion device, String contentType, Buffer payload, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        this.log.trace("sending event [tenantId: {}, deviceId: {}, contentType: {}, properties: {}]", new Object[]{tenant.getTenantId(), device.getDeviceId(), contentType, properties});
        HonoTopic topic = new HonoTopic(HonoTopic.Type.EVENT, tenant.getTenantId());
        return this.send(topic, tenant, device, QoS.AT_LEAST_ONCE, contentType, payload, properties, "forward Event", context);
    }

    public String toString() {
        return KafkaBasedEventSender.class.getName() + " via Kafka";
    }
}

