/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.telemetry.kafka;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.producer.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.producer.MessagingKafkaProducerConfigProperties;
import org.eclipse.hono.client.telemetry.TelemetrySender;
import org.eclipse.hono.client.telemetry.kafka.AbstractKafkaBasedDownstreamSender;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;

public class KafkaBasedTelemetrySender
extends AbstractKafkaBasedDownstreamSender
implements TelemetrySender {
    public KafkaBasedTelemetrySender(Vertx vertx, KafkaProducerFactory<String, Buffer> producerFactory, MessagingKafkaProducerConfigProperties kafkaProducerConfig, boolean includeDefaults, Tracer tracer) {
        super(vertx, producerFactory, "telemetry", kafkaProducerConfig, includeDefaults, tracer);
    }

    @Override
    protected HonoTopic.Type getTopicType() {
        return HonoTopic.Type.TELEMETRY;
    }

    public Future<Void> sendTelemetry(TenantObject tenant, RegistrationAssertion device, QoS qos, String contentType, Buffer payload, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        Objects.requireNonNull(qos);
        if (this.log.isTraceEnabled()) {
            this.log.trace("send telemetry data [tenantId: {}, deviceId: {}, qos: {}, contentType: {}, properties: {}]", new Object[]{tenant.getTenantId(), device.getDeviceId(), qos, contentType, properties});
        }
        HonoTopic topic = new HonoTopic(HonoTopic.Type.TELEMETRY, tenant.getTenantId());
        Map<String, Object> propsWithDefaults = this.addDefaults(topic.getType().endpoint, tenant, device, qos, contentType, payload, properties);
        String topicName = topic.toString();
        Span currentSpan = this.startSpan("forward Telemetry", topicName, tenant.getTenantId(), device.getDeviceId(), qos == QoS.AT_MOST_ONCE ? "follows_from" : "child_of", context);
        Future outcome = this.sendAndWaitForOutcome(topic.toString(), tenant.getTenantId(), device.getDeviceId(), payload, propsWithDefaults, currentSpan).onComplete(ar -> currentSpan.finish());
        if (qos == QoS.AT_MOST_ONCE) {
            return Future.succeededFuture();
        }
        return outcome;
    }

    public String toString() {
        return KafkaBasedTelemetrySender.class.getName() + " via Kafka";
    }
}

