/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.telemetry.kafka;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.producer.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.producer.KafkaProducerFactory;
import org.eclipse.hono.client.telemetry.TelemetrySender;
import org.eclipse.hono.client.telemetry.kafka.AbstractKafkaBasedDownstreamSender;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TenantObject;

public class KafkaBasedTelemetrySender
extends AbstractKafkaBasedDownstreamSender
implements TelemetrySender {
    public KafkaBasedTelemetrySender(KafkaProducerFactory<String, Buffer> producerFactory, KafkaProducerConfigProperties kafkaProducerConfig, boolean includeDefaults, Tracer tracer) {
        super(producerFactory, "telemetry", kafkaProducerConfig, includeDefaults, tracer);
    }

    public Future<Void> sendTelemetry(TenantObject tenant, RegistrationAssertion device, QoS qos, String contentType, Buffer payload, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        Objects.requireNonNull(qos);
        this.log.trace("send telemetry data [tenantId: {}, deviceId: {}, qos: {}, contentType: {}, properties: {}]", new Object[]{tenant.getTenantId(), device.getDeviceId(), qos, contentType, properties});
        HonoTopic topic = new HonoTopic(HonoTopic.Type.TELEMETRY, tenant.getTenantId());
        return this.send(topic, tenant, device, qos, contentType, payload, properties, "forward Telemetry data", context);
    }

    public String toString() {
        return KafkaBasedTelemetrySender.class.getName() + " via Kafka";
    }
}

