/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.registry.amqp;

import com.github.benmanes.caffeine.cache.Cache;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.StringTag;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.amqp.AbstractRequestResponseServiceClient;
import org.eclipse.hono.client.amqp.RequestResponseClient;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.client.util.AnnotatedCacheKey;
import org.eclipse.hono.client.util.CachingClientFactory;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.LifecycleChange;
import org.eclipse.hono.notification.deviceregistry.TenantChangeNotification;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.TenantConstants;
import org.eclipse.hono.util.TenantObject;
import org.eclipse.hono.util.TenantResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtonBasedTenantClient
extends AbstractRequestResponseServiceClient<TenantObject, TenantResult<TenantObject>>
implements TenantClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedTenantClient.class);
    private static final StringTag TAG_SUBJECT_DN = new StringTag("subject_dn");
    private static final String ATTRIBUTE_KEY_TENANT_ID = "tenant-id";
    private final Map<Object, Future<TenantResult<TenantObject>>> pendingRequests = new HashMap<Object, Future<TenantResult<TenantObject>>>();

    public ProtonBasedTenantClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory, Cache<Object, TenantResult<TenantObject>> responseCache) {
        super(connection, samplerFactory, new CachingClientFactory(connection.getVertx(), RequestResponseClient::isOpen), responseCache);
        if (this.isCachingEnabled()) {
            NotificationEventBusSupport.registerConsumer((Vertx)connection.getVertx(), (NotificationType)TenantChangeNotification.TYPE, n -> {
                if (LifecycleChange.DELETE.equals((Object)n.getChange()) || LifecycleChange.UPDATE.equals((Object)n.getChange()) && (!n.isTenantEnabled() || n.isInvalidateCacheOnUpdate())) {
                    this.removeResultFromCache(n.getTenantId());
                }
            });
        }
    }

    protected String getKey(String tenantId) {
        return "tenant";
    }

    private Future<RequestResponseClient<TenantResult<TenantObject>>> getOrCreateClient() {
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> this.clientFactory.getOrCreateClient("tenant", () -> RequestResponseClient.forEndpoint((HonoConnection)this.connection, (String)"tenant", null, (SendMessageSampler)this.samplerFactory.create("tenant"), x$0 -> this.removeClient((String)x$0), x$0 -> this.removeClient((String)x$0)), (Handler)result)));
    }

    protected TenantResult<TenantObject> getResult(int status, String contentType, Buffer payload, CacheDirective cacheDirective, ApplicationProperties applicationProperties) {
        Map props = Optional.ofNullable(applicationProperties).map(ApplicationProperties::getValue).orElse(null);
        if (this.isSuccessResponse(status, contentType, payload)) {
            try {
                return TenantResult.from((int)status, (Object)((TenantObject)Json.decodeValue((Buffer)payload, TenantObject.class)), (CacheDirective)cacheDirective, (Map)props);
            }
            catch (DecodeException e) {
                LOG.warn("received malformed payload from Tenant service", (Throwable)e);
                return TenantResult.from((int)500, null, null, (Map)props);
            }
        }
        return TenantResult.from((int)status, null, null, (Map)props);
    }

    public Future<TenantObject> get(String tenantId, SpanContext parent) {
        Objects.requireNonNull(tenantId);
        AnnotatedCacheKey responseCacheKey = new AnnotatedCacheKey((Object)tenantId);
        Span span = this.newChildSpan(parent, "get Tenant by ID");
        span.setTag("tenant_id", tenantId);
        return this.get(responseCacheKey, () -> new JsonObject().put(ATTRIBUTE_KEY_TENANT_ID, (Object)tenantId), span);
    }

    public Future<TenantObject> get(X500Principal subjectDn, SpanContext parent) {
        Objects.requireNonNull(subjectDn);
        String subjectDnRfc2253 = subjectDn.getName("RFC2253");
        AnnotatedCacheKey responseCacheKey = new AnnotatedCacheKey((Object)subjectDn);
        Span span = this.newChildSpan(parent, "get Tenant by subject DN");
        TAG_SUBJECT_DN.set(span, subjectDnRfc2253);
        return this.get(responseCacheKey, () -> new JsonObject().put("subject-dn", (Object)subjectDnRfc2253), span);
    }

    private Future<TenantObject> get(AnnotatedCacheKey<?> responseCacheKey, Supplier<JsonObject> payloadSupplier, Span currentSpan) {
        Future resultTracker = this.getResponseFromCache(responseCacheKey, currentSpan).recover(cacheMiss -> this.executeOrUsePendingRequestResult(responseCacheKey, () -> this.lambda$get$10((Supplier)payloadSupplier, currentSpan)));
        return this.mapResultAndFinishSpan(resultTracker, tenantResult -> {
            switch (tenantResult.getStatus()) {
                case 200: {
                    return (TenantObject)tenantResult.getPayload();
                }
                case 404: {
                    throw new ClientErrorException(tenantResult.getStatus(), "no such tenant");
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)tenantResult);
        }, currentSpan);
    }

    private Future<TenantResult<TenantObject>> executeOrUsePendingRequestResult(AnnotatedCacheKey<?> responseCacheKey, Supplier<Future<TenantResult<TenantObject>>> serviceRequest) {
        Promise resultPromise = Promise.promise();
        Optional.ofNullable(this.pendingRequests.putIfAbsent(responseCacheKey, (Future<TenantResult<TenantObject>>)resultPromise.future())).ifPresentOrElse(pendingRequest -> pendingRequest.onComplete((Handler)resultPromise), () -> ((Future)serviceRequest.get()).onSuccess(tenantResult -> this.addResultToCache(responseCacheKey, (TenantResult<TenantObject>)tenantResult)).onComplete(ar -> this.pendingRequests.remove(responseCacheKey)).onComplete((Handler)resultPromise));
        return resultPromise.future();
    }

    private void addResultToCache(AnnotatedCacheKey<?> responseCacheKey, TenantResult<TenantObject> tenantResult) {
        if (this.isCachingEnabled()) {
            if (tenantResult.getPayload() != null) {
                responseCacheKey.putAttribute(ATTRIBUTE_KEY_TENANT_ID, ((TenantObject)tenantResult.getPayload()).getTenantId());
            }
            this.addToCache(responseCacheKey, (RequestResponseResult)tenantResult);
        }
    }

    private void removeResultFromCache(String tenantId) {
        this.removeFromCacheByPattern(key -> ((AnnotatedCacheKey)key).getAttribute(ATTRIBUTE_KEY_TENANT_ID).map(id -> id.equals(tenantId)).orElse(false));
    }

    private /* synthetic */ Future lambda$get$10(Supplier payloadSupplier, Span currentSpan) {
        return this.getOrCreateClient().compose(arg_0 -> this.lambda$get$9((Supplier)payloadSupplier, currentSpan, arg_0));
    }

    private /* synthetic */ Future lambda$get$9(Supplier payloadSupplier, Span currentSpan, RequestResponseClient client) {
        return client.createAndSendRequest(TenantConstants.TenantAction.get.toString(), null, ((JsonObject)payloadSupplier.get()).toBuffer(), "application/json", x$0 -> (TenantResult)this.getRequestResponseResult((Message)x$0), currentSpan);
    }
}

