/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.registry.amqp;

import com.github.benmanes.caffeine.cache.Cache;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.amqp.AbstractRequestResponseServiceClient;
import org.eclipse.hono.client.amqp.RequestResponseClient;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.registry.DeviceRegistrationClient;
import org.eclipse.hono.client.util.AnnotatedCacheKey;
import org.eclipse.hono.client.util.CachingClientFactory;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.AllDevicesOfTenantDeletedNotification;
import org.eclipse.hono.notification.deviceregistry.DeviceChangeNotification;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.RegistrationResult;
import org.eclipse.hono.util.RequestResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonBasedDeviceRegistrationClient
extends AbstractRequestResponseServiceClient<JsonObject, RegistrationResult>
implements DeviceRegistrationClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedDeviceRegistrationClient.class);

    public ProtonBasedDeviceRegistrationClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory, Cache<Object, RegistrationResult> responseCache) {
        super(connection, samplerFactory, new CachingClientFactory(connection.getVertx(), RequestResponseClient::isOpen), responseCache);
        connection.getVertx().eventBus().consumer("tenant.timeout", x$0 -> this.handleTenantTimeout((Message)x$0));
        if (this.isCachingEnabled()) {
            NotificationEventBusSupport.registerConsumer((Vertx)connection.getVertx(), (NotificationType)AllDevicesOfTenantDeletedNotification.TYPE, n -> this.removeResultsForTenantFromCache(n.getTenantId()));
            NotificationEventBusSupport.registerConsumer((Vertx)connection.getVertx(), (NotificationType)DeviceChangeNotification.TYPE, n -> this.removeResultsForDeviceFromCache(n.getTenantId(), n.getDeviceId()));
        }
    }

    protected String getKey(String tenantId) {
        return String.format("%s-%s", "registration", tenantId);
    }

    private Future<RequestResponseClient<RegistrationResult>> getOrCreateClient(String tenantId) {
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> this.clientFactory.getOrCreateClient(this.getKey(tenantId), () -> RequestResponseClient.forEndpoint((HonoConnection)this.connection, (String)"registration", (String)tenantId, (SendMessageSampler)this.samplerFactory.create("registration"), x$0 -> this.removeClient((String)x$0), x$0 -> this.removeClient((String)x$0)), (Handler)result)));
    }

    protected final RegistrationResult getResult(int status, String contentType, Buffer payload, CacheDirective cacheDirective, ApplicationProperties applicationProperties) {
        Map props = Optional.ofNullable(applicationProperties).map(ApplicationProperties::getValue).orElse(null);
        if (this.isSuccessResponse(status, contentType, payload)) {
            try {
                return RegistrationResult.from((int)status, (JsonObject)new JsonObject(payload), (CacheDirective)cacheDirective, (Map)props);
            }
            catch (DecodeException e) {
                LOG.warn("received malformed payload from Device Registration service", (Throwable)e);
                return RegistrationResult.from((int)500, null, null, (Map)props);
            }
        }
        return RegistrationResult.from((int)status, null, null, (Map)props);
    }

    public Future<RegistrationAssertion> assertRegistration(String tenantId, String deviceId, String gatewayId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        AnnotatedCacheKey responseCacheKey = new AnnotatedCacheKey((Object)new CacheKey(tenantId, deviceId, gatewayId));
        Span span = this.newChildSpan(context, "assert Device Registration");
        TracingHelper.setDeviceTags((Span)span, (String)tenantId, (String)deviceId);
        TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
        return this.getResponseFromCache(responseCacheKey, span).recover(t -> this.getOrCreateClient(tenantId).compose(client -> {
            Map properties = this.createDeviceIdProperties(deviceId);
            if (gatewayId != null) {
                properties.put("gateway_id", gatewayId);
            }
            return client.createAndSendRequest("assert", properties, null, "application/json", x$0 -> (RegistrationResult)this.getRequestResponseResult((org.apache.qpid.proton.message.Message)x$0), span);
        }).map(registrationResult -> {
            this.addToCache(responseCacheKey, (RequestResponseResult)registrationResult);
            return registrationResult;
        })).recover(t -> {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(ServiceInvocationException.extractStatusCode((Throwable)t)));
            TracingHelper.logError((Span)span, (Throwable)t);
            return Future.failedFuture((Throwable)t);
        }).map(registrationResult -> {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(registrationResult.getStatus()));
            if (registrationResult.isError()) {
                Tags.ERROR.set(span, Boolean.TRUE);
            }
            switch (registrationResult.getStatus()) {
                case 200: {
                    JsonObject payload = (JsonObject)registrationResult.getPayload();
                    try {
                        return (RegistrationAssertion)payload.mapTo(RegistrationAssertion.class);
                    }
                    catch (DecodeException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("registration service returned invalid response:{}{}", (Object)System.lineSeparator(), (Object)payload.encodePrettily());
                        }
                        TracingHelper.logError((Span)span, (String)"registration service returned invalid response", (Throwable)e);
                        throw new ServerErrorException(500, "registration service returned invalid response");
                    }
                }
                case 404: {
                    throw new ClientErrorException(registrationResult.getStatus(), "device unknown or disabled");
                }
                case 403: {
                    throw new ClientErrorException(registrationResult.getStatus(), "gateway unknown, disabled or not authorized to act on behalf of device");
                }
            }
            throw StatusCodeMapper.from((RegistrationResult)registrationResult);
        }).onComplete(o -> span.finish());
    }

    private void removeResultsForTenantFromCache(String tenantId) {
        this.removeFromCacheByPattern(k -> ((CacheKey)((AnnotatedCacheKey)k).getKey()).tenantId.equals(tenantId));
    }

    private void removeResultsForDeviceFromCache(String tenantId, String deviceId) {
        this.removeFromCacheByPattern(key -> {
            CacheKey cacheKey = (CacheKey)((AnnotatedCacheKey)key).getKey();
            boolean tenantMatches = cacheKey.tenantId.equals(tenantId);
            boolean deviceOrGatewayMatches = cacheKey.deviceId.equals(deviceId) || Objects.equals(cacheKey.gatewayId, deviceId);
            return tenantMatches && deviceOrGatewayMatches;
        });
    }

    private static class CacheKey {
        final String tenantId;
        final String deviceId;
        final String gatewayId;

        CacheKey(String tenantId, String deviceId, String gatewayId) {
            Objects.requireNonNull(tenantId);
            Objects.requireNonNull(deviceId);
            this.tenantId = tenantId;
            this.deviceId = deviceId;
            this.gatewayId = gatewayId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.tenantId.equals(cacheKey.tenantId) && this.deviceId.equals(cacheKey.deviceId) && Objects.equals(this.gatewayId, cacheKey.gatewayId);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.deviceId, this.gatewayId);
        }

        public String toString() {
            return "CacheKey{tenantId='" + this.tenantId + "', deviceId='" + this.deviceId + "', gatewayId='" + this.gatewayId + "'}";
        }
    }
}

