/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.registry.amqp;

import com.github.benmanes.caffeine.cache.Cache;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.amqp.AbstractRequestResponseServiceClient;
import org.eclipse.hono.client.amqp.RequestResponseClient;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.client.util.AnnotatedCacheKey;
import org.eclipse.hono.client.util.CachingClientFactory;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.notification.NotificationEventBusSupport;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.AllDevicesOfTenantDeletedNotification;
import org.eclipse.hono.notification.deviceregistry.CredentialsChangeNotification;
import org.eclipse.hono.notification.deviceregistry.DeviceChangeNotification;
import org.eclipse.hono.notification.deviceregistry.LifecycleChange;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.CredentialsObject;
import org.eclipse.hono.util.CredentialsResult;
import org.eclipse.hono.util.RequestResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonBasedCredentialsClient
extends AbstractRequestResponseServiceClient<CredentialsObject, CredentialsResult<CredentialsObject>>
implements CredentialsClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedCredentialsClient.class);
    private static final String TAG_AUTH_ID = "auth_id";
    private static final String TAG_CREDENTIALS_TYPE = "credentials_type";
    private static final String ATTRIBUTE_KEY_DEVICE_ID = "device-id";

    public ProtonBasedCredentialsClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory, Cache<Object, CredentialsResult<CredentialsObject>> responseCache) {
        super(connection, samplerFactory, new CachingClientFactory(connection.getVertx(), RequestResponseClient::isOpen), responseCache);
        connection.getVertx().eventBus().consumer("tenant.timeout", x$0 -> this.handleTenantTimeout((Message)x$0));
        if (this.isCachingEnabled()) {
            NotificationEventBusSupport.registerConsumer((Vertx)connection.getVertx(), (NotificationType)AllDevicesOfTenantDeletedNotification.TYPE, n -> this.removeResultsForTenantFromCache(n.getTenantId()));
            NotificationEventBusSupport.registerConsumer((Vertx)connection.getVertx(), (NotificationType)DeviceChangeNotification.TYPE, n -> {
                if (LifecycleChange.DELETE.equals((Object)n.getChange()) || LifecycleChange.UPDATE.equals((Object)n.getChange()) && !n.isDeviceEnabled()) {
                    this.removeResultsForDeviceFromCache(n.getTenantId(), n.getDeviceId());
                }
            });
            NotificationEventBusSupport.registerConsumer((Vertx)connection.getVertx(), (NotificationType)CredentialsChangeNotification.TYPE, n -> this.removeResultsForDeviceFromCache(n.getTenantId(), n.getDeviceId()));
        }
    }

    protected String getKey(String tenantId) {
        return String.format("%s-%s", "credentials", tenantId);
    }

    private Future<RequestResponseClient<CredentialsResult<CredentialsObject>>> getOrCreateClient(String tenantId) {
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> this.clientFactory.getOrCreateClient(this.getKey(tenantId), () -> RequestResponseClient.forEndpoint((HonoConnection)this.connection, (String)"credentials", (String)tenantId, (SendMessageSampler)this.samplerFactory.create("credentials"), x$0 -> this.removeClient((String)x$0), x$0 -> this.removeClient((String)x$0)), (Handler)result)));
    }

    protected final CredentialsResult<CredentialsObject> getResult(int status, String contentType, Buffer payload, CacheDirective cacheDirective, ApplicationProperties applicationProperties) {
        Map props = Optional.ofNullable(applicationProperties).map(ApplicationProperties::getValue).orElse(null);
        if (this.isSuccessResponse(status, contentType, payload)) {
            try {
                return CredentialsResult.from((int)status, (Object)((CredentialsObject)Json.decodeValue((Buffer)payload, CredentialsObject.class)), (CacheDirective)cacheDirective, (Map)props);
            }
            catch (DecodeException e) {
                LOG.warn("received malformed payload from Credentials service", (Throwable)e);
                return CredentialsResult.from((int)500, null, null, (Map)props);
            }
        }
        return CredentialsResult.from((int)status, null, null, (Map)props);
    }

    public Future<CredentialsObject> get(String tenantId, String type, String authId, SpanContext spanContext) {
        return this.get(tenantId, type, authId, new JsonObject(), spanContext);
    }

    public Future<CredentialsObject> get(String tenantId, String type, String authId, JsonObject clientContext, SpanContext spanContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(type);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(clientContext);
        int clientContextHashCode = clientContext.isEmpty() ? clientContext.hashCode() : new JsonObject(clientContext.encode()).hashCode();
        AnnotatedCacheKey responseCacheKey = new AnnotatedCacheKey((Object)new CacheKey(tenantId, type, authId, clientContextHashCode));
        Span span = this.newChildSpan(spanContext, "get Credentials");
        span.setTag("tenant_id", tenantId);
        span.setTag(TAG_CREDENTIALS_TYPE, type);
        span.setTag(TAG_AUTH_ID, authId);
        Future resultTracker = this.getResponseFromCache(responseCacheKey, span).recover(cacheMiss -> this.getOrCreateClient(tenantId).compose(client -> {
            JsonObject specification = CredentialsConstants.getSearchCriteria((String)type, (String)authId).mergeIn(clientContext);
            if (LOG.isTraceEnabled()) {
                LOG.trace("getting credentials using spec:{}{}", (Object)System.lineSeparator(), (Object)specification.encodePrettily());
            }
            return client.createAndSendRequest(CredentialsConstants.CredentialsAction.get.toString(), null, specification.toBuffer(), "application/json", x$0 -> (CredentialsResult)this.getRequestResponseResult((org.apache.qpid.proton.message.Message)x$0), span);
        }).map(credentialsResult -> {
            this.addResultToCache((AnnotatedCacheKey<CacheKey>)responseCacheKey, (CredentialsResult<CredentialsObject>)credentialsResult);
            return credentialsResult;
        }));
        return this.mapResultAndFinishSpan(resultTracker, result -> {
            switch (result.getStatus()) {
                case 200: 
                case 201: {
                    return (CredentialsObject)result.getPayload();
                }
                case 404: {
                    throw new ClientErrorException(result.getStatus(), "no such credentials");
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)result);
        }, span);
    }

    private void addResultToCache(AnnotatedCacheKey<CacheKey> responseCacheKey, CredentialsResult<CredentialsObject> credentialsResult) {
        if (this.isCachingEnabled()) {
            if (credentialsResult.getPayload() != null) {
                responseCacheKey.putAttribute(ATTRIBUTE_KEY_DEVICE_ID, ((CredentialsObject)credentialsResult.getPayload()).getDeviceId());
            }
            this.addToCache(responseCacheKey, (RequestResponseResult)credentialsResult);
        }
    }

    private void removeResultsForTenantFromCache(String tenantId) {
        this.removeFromCacheByPattern(k -> ((CacheKey)((AnnotatedCacheKey)k).getKey()).tenantId.equals(tenantId));
    }

    private void removeResultsForDeviceFromCache(String tenantId, String deviceId) {
        this.removeFromCacheByPattern(key -> {
            AnnotatedCacheKey annotatedCacheKey = (AnnotatedCacheKey)key;
            boolean tenantMatches = ((CacheKey)annotatedCacheKey.getKey()).tenantId.equals(tenantId);
            Boolean deviceMatches = annotatedCacheKey.getAttribute(ATTRIBUTE_KEY_DEVICE_ID).map(id -> id.equals(deviceId)).orElse(false);
            return tenantMatches && deviceMatches != false;
        });
    }

    private static class CacheKey {
        final String tenantId;
        final String type;
        final String authId;
        final int clientContextHashCode;

        CacheKey(String tenantId, String type, String authId, int clientContextHashCode) {
            Objects.requireNonNull(tenantId);
            Objects.requireNonNull(type);
            Objects.requireNonNull(authId);
            this.tenantId = tenantId;
            this.type = type;
            this.authId = authId;
            this.clientContextHashCode = clientContextHashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.clientContextHashCode == cacheKey.clientContextHashCode && this.tenantId.equals(cacheKey.tenantId) && this.type.equals(cacheKey.type) && this.authId.equals(cacheKey.authId);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.type, this.authId, this.clientContextHashCode);
        }

        public String toString() {
            return "CacheKey{tenantId='" + this.tenantId + "', type='" + this.type + "', authId='" + this.authId + "', clientContextHashCode=" + this.clientContextHashCode + "}";
        }
    }
}

