/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.pubsub.subscriber;

import com.google.api.gax.core.CredentialsProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.pubsub.v1.ProjectSubscriptionName;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.client.pubsub.subscriber.PubSubSubscriberClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubSubscriberClientImpl
implements PubSubSubscriberClient {
    private static final int SUBSCRIBE_RETRY_DELAY_MILLIS = 60000;
    private final Logger log = LoggerFactory.getLogger(PubSubSubscriberClientImpl.class);
    private final Subscriber subscriber;
    private final Vertx vertx;

    public PubSubSubscriberClientImpl(Vertx vertx, String projectId, String subscriptionId, MessageReceiver receiver, CredentialsProvider credentialsProvider) {
        this.vertx = Objects.requireNonNull(vertx);
        Objects.requireNonNull(projectId);
        Objects.requireNonNull(subscriptionId);
        Objects.requireNonNull(receiver);
        Objects.requireNonNull(credentialsProvider);
        ProjectSubscriptionName subscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscriptionId);
        this.subscriber = Subscriber.newBuilder((ProjectSubscriptionName)subscriptionName, (MessageReceiver)receiver).setCredentialsProvider(credentialsProvider).build();
    }

    @Override
    public Future<Void> subscribe(boolean keepTrying) {
        Promise resultPromise = Promise.promise();
        this.subscribeWithRetries((Promise<Void>)resultPromise, keepTrying);
        return resultPromise.future();
    }

    private void subscribeWithRetries(Promise<Void> resultPromise, boolean keepTrying) {
        try {
            this.subscriber.startAsync().awaitRunning();
            this.log.info("Successfully subscribing on: {}", (Object)this.subscriber.getSubscriptionNameString());
            resultPromise.complete();
        }
        catch (Exception e) {
            if (keepTrying) {
                this.log.info("Error subscribing message from Pub/Sub, will retry in {}ms: ", (Object)60000, (Object)e);
                this.vertx.setTimer(60000L, tid -> this.subscribeWithRetries(resultPromise, keepTrying));
            }
            this.log.error("Error subscribing message from Pub/Sub", (Throwable)e);
            resultPromise.fail((Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.subscriber != null) {
            this.subscriber.stopAsync();
        }
    }
}

