/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.notification.deviceregistry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationType;
import org.eclipse.hono.notification.deviceregistry.LifecycleChange;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class DeviceChangeNotification
extends AbstractNotification {
    public static final String TYPE_NAME = "device-change-v1";
    public static final String ADDRESS = "registry-device";
    public static final NotificationType<DeviceChangeNotification> TYPE = new NotificationType<DeviceChangeNotification>("device-change-v1", DeviceChangeNotification.class, "registry-device");
    private final LifecycleChange change;
    private final String tenantId;
    private final String deviceId;
    private final boolean enabled;

    @JsonCreator
    DeviceChangeNotification(@JsonProperty(value="source", required=true) String source, @JsonProperty(value="creation-time", required=true) @HonoTimestamp Instant creationTime, @JsonProperty(value="change", required=true) LifecycleChange change, @JsonProperty(value="tenant-id", required=true) String tenantId, @JsonProperty(value="device-id", required=true) String deviceId, @JsonProperty(value="enabled", required=true) boolean enabled) {
        super(source, creationTime);
        this.change = Objects.requireNonNull(change);
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.enabled = enabled;
    }

    public DeviceChangeNotification(LifecycleChange change, String tenantId, String deviceId, Instant creationTime, boolean enabled) {
        this("device-registry", creationTime, change, tenantId, deviceId, enabled);
    }

    @JsonProperty(value="change")
    public LifecycleChange getChange() {
        return this.change;
    }

    @JsonProperty(value="tenant-id")
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="device-id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonIgnore
    public NotificationType<DeviceChangeNotification> getType() {
        return TYPE;
    }

    @Override
    @JsonIgnore
    public String getKey() {
        return this.getDeviceId();
    }

    public String toString() {
        return "DeviceChangeNotification{change=" + this.change + ", tenantId='" + this.tenantId + "', deviceId='" + this.deviceId + "', enabled=" + this.enabled + ", creationTime='" + this.getCreationTime() + "'}";
    }
}

