/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.notification.amqp;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.SenderCachingServiceClient;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.notification.amqp.NotificationAddressHelper;
import org.eclipse.hono.notification.AbstractNotification;
import org.eclipse.hono.notification.NotificationSender;

public class ProtonBasedNotificationSender
extends SenderCachingServiceClient
implements NotificationSender {
    public ProtonBasedNotificationSender(HonoConnection connection) {
        super(connection, SendMessageSampler.Factory.noop(), false);
    }

    public Future<Void> publish(AbstractNotification notification) {
        Objects.requireNonNull(notification);
        return this.getOrCreateSenderLink(NotificationAddressHelper.getAddress(notification.getType())).compose(sender -> sender.sendAndWaitForOutcome(this.createMessage(notification), (Span)NoopSpan.INSTANCE).onFailure(thr -> this.log.debug("error sending notification [{}]", (Object)notification, thr))).mapEmpty();
    }

    private Message createMessage(AbstractNotification notification) {
        Message msg = ProtonHelper.message();
        JsonObject value = JsonObject.mapFrom((Object)notification);
        AmqpUtils.setJsonPayload((Message)msg, (JsonObject)value);
        msg.setAddress(NotificationAddressHelper.getAddress(notification.getType()));
        return msg;
    }
}

