/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.consumer;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.kafka.client.common.impl.Helper;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public abstract class HonoKafkaConsumerHelper {
    private HonoKafkaConsumerHelper() {
    }

    public static void partitionsFor(KafkaConsumer<?, ?> kafkaConsumer, String topic, Handler<AsyncResult<List<io.vertx.kafka.client.common.PartitionInfo>>> handler) {
        Objects.requireNonNull(kafkaConsumer);
        Objects.requireNonNull(topic);
        Objects.requireNonNull(handler);
        kafkaConsumer.asStream().partitionsFor(topic, done -> {
            if (done.succeeded()) {
                if (done.result() == null) {
                    handler.handle((Object)Future.succeededFuture(List.of()));
                } else {
                    ArrayList<io.vertx.kafka.client.common.PartitionInfo> partitions = new ArrayList<io.vertx.kafka.client.common.PartitionInfo>();
                    for (PartitionInfo kafkaPartitionInfo : (List)done.result()) {
                        io.vertx.kafka.client.common.PartitionInfo partitionInfo = new io.vertx.kafka.client.common.PartitionInfo();
                        partitionInfo.setInSyncReplicas(Stream.of(kafkaPartitionInfo.inSyncReplicas()).map(Helper::from).collect(Collectors.toList())).setLeader(Helper.from((Node)kafkaPartitionInfo.leader())).setPartition(kafkaPartitionInfo.partition()).setReplicas(Stream.of(kafkaPartitionInfo.replicas()).map(Helper::from).collect(Collectors.toList())).setTopic(kafkaPartitionInfo.topic());
                        partitions.add(partitionInfo);
                    }
                    handler.handle((Object)Future.succeededFuture(partitions));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)done.cause()));
            }
        });
    }

    public static String getPartitionsDebugString(Collection<TopicPartition> partitionsSet) {
        Objects.requireNonNull(partitionsSet);
        return partitionsSet.size() <= 20 ? partitionsSet.stream().collect(Collectors.groupingBy(TopicPartition::topic, Collectors.mapping(TopicPartition::partition, Collectors.toCollection(TreeSet::new)))).toString() : partitionsSet.size() + " topic partitions";
    }

    public static String getOffsetsDebugString(Map<TopicPartition, OffsetAndMetadata> offsets) {
        Objects.requireNonNull(offsets);
        return offsets.size() <= 20 ? offsets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((OffsetAndMetadata)entry.getValue()).offset())).toString() : offsets.size() + " offsets";
    }
}

