/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.kafka.AbstractKafkaConfigProperties;

public class KafkaConsumerConfigProperties
extends AbstractKafkaConfigProperties {
    public static final long DEFAULT_POLL_TIMEOUT = 100L;
    private Map<String, String> consumerConfig;
    private long pollTimeout = 100L;

    public final void setConsumerConfig(Map<String, String> consumerConfig) {
        this.consumerConfig = Objects.requireNonNull(consumerConfig);
    }

    public final boolean isConfigured() {
        return this.commonClientConfig != null || this.consumerConfig != null;
    }

    public final Map<String, String> getConsumerConfig(String consumerName) {
        Objects.requireNonNull(consumerName);
        if (this.commonClientConfig == null && this.consumerConfig == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> newConfig = new HashMap<String, String>();
        if (this.commonClientConfig != null) {
            newConfig.putAll(this.commonClientConfig);
        }
        if (this.consumerConfig != null) {
            newConfig.putAll(this.consumerConfig);
        }
        this.overrideConfigProperty(newConfig, "key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.overrideConfigProperty(newConfig, "value.deserializer", "io.vertx.kafka.client.serialization.BufferDeserializer");
        this.setUniqueClientId(newConfig, consumerName, "client.id");
        return newConfig;
    }

    public final void setPollTimeout(long pollTimeoutMillis) {
        if (pollTimeoutMillis < 0L) {
            throw new IllegalArgumentException("poll timeout must not be negative");
        }
        this.pollTimeout = pollTimeoutMillis;
    }

    public final long getPollTimeout() {
        return this.pollTimeout;
    }
}

