/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.kafka.client.producer.KafkaHeader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(RecordUtil.class);

    private RecordUtil() {
    }

    public static String getStringHeaderValue(Collection<KafkaHeader> headers, String name) {
        return RecordUtil.getHeaderValue(headers, name, String.class);
    }

    public static <T> T getHeaderValue(Collection<KafkaHeader> headers, String name, Class<T> type) {
        Buffer value;
        Objects.requireNonNull(headers);
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        Object result = null;
        Iterator matchingHeaders = headers.stream().filter(h -> name.equals(h.key())).iterator();
        if (matchingHeaders.hasNext() && (value = ((KafkaHeader)matchingHeaders.next()).value()) != null && !matchingHeaders.hasNext()) {
            if (type.equals(String.class)) {
                result = value.toString();
            } else {
                try {
                    result = Json.decodeValue((Buffer)value, type);
                }
                catch (DecodeException e) {
                    LOG.trace("header value '{}' not of given type {}", new Object[]{value, type.getSimpleName(), e});
                }
            }
        }
        return (T)result;
    }
}

