/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.Json;
import io.vertx.kafka.client.producer.KafkaHeader;
import io.vertx.kafka.client.producer.impl.KafkaHeaderImpl;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.QoS;

public final class KafkaMessageHelper {
    private KafkaMessageHelper() {
    }

    public static KafkaHeader createKafkaHeader(String key, Object value) throws EncodeException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        String encodedValue = value instanceof String ? (String)value : Json.encode((Object)value);
        return new KafkaHeaderImpl(key, Buffer.buffer((String)encodedValue));
    }

    public static Optional<String> getContentType(List<KafkaHeader> headers) {
        return KafkaMessageHelper.getHeaderValue(headers, "content-type", String.class);
    }

    public static Optional<QoS> getQoS(List<KafkaHeader> headers) {
        return KafkaMessageHelper.getHeaderValue(headers, "qos", Integer.class).map(integer -> Integer.valueOf(0).equals(integer) ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE);
    }

    public static <T> Optional<T> getHeaderValue(List<KafkaHeader> headers, String key, Class<T> type) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (headers == null) {
            return Optional.empty();
        }
        return headers.stream().filter(h -> key.equals(h.key())).findFirst().map(h -> KafkaMessageHelper.decode(h, type));
    }

    public static <T> T decode(KafkaHeader header, Class<T> type) {
        Objects.requireNonNull(type);
        if (header == null) {
            return null;
        }
        return KafkaMessageHelper.decode(header.value(), type);
    }

    public static <T> T decode(Buffer encodedHeaderValue, Class<T> type) {
        Objects.requireNonNull(type);
        if (encodedHeaderValue == null) {
            return null;
        }
        try {
            if (String.class.equals(type)) {
                return (T)encodedHeaderValue.toString();
            }
            return (T)Json.decodeValue((Buffer)encodedHeaderValue, type);
        }
        catch (DecodeException ex) {
            return null;
        }
    }
}

