/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import java.util.Objects;

public final class HonoTopic {
    private final Type type;
    private final String tenantId;
    private final String topicString;

    public HonoTopic(Type type, String tenantId) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(tenantId);
        this.type = type;
        this.tenantId = tenantId;
        this.topicString = type.prefix + tenantId;
    }

    public static HonoTopic fromString(String topicString) {
        Objects.requireNonNull(topicString);
        Type type = null;
        if (topicString.startsWith(Type.TELEMETRY.prefix)) {
            type = Type.TELEMETRY;
        } else if (topicString.startsWith(Type.EVENT.prefix)) {
            type = Type.EVENT;
        } else if (topicString.startsWith(Type.COMMAND.prefix)) {
            type = Type.COMMAND;
        } else if (topicString.startsWith(Type.COMMAND_RESPONSE.prefix)) {
            type = Type.COMMAND_RESPONSE;
        }
        if (type != null) {
            String tenantId = topicString.substring(type.prefix.length());
            return !tenantId.isEmpty() ? new HonoTopic(type, tenantId) : null;
        }
        return null;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.topicString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HonoTopic honoTopic = (HonoTopic)o;
        return this.topicString.equals(honoTopic.topicString);
    }

    public int hashCode() {
        return Objects.hash(this.topicString);
    }

    public static enum Type {
        TELEMETRY("telemetry"),
        EVENT("event"),
        COMMAND("command"),
        COMMAND_RESPONSE("command_response");

        private static final String SEPARATOR = ".";
        private static final String NAMESPACE = "hono";
        public final String endpoint;
        public final String prefix;

        private Type(String endpoint) {
            this.endpoint = endpoint;
            this.prefix = "hono." + endpoint + SEPARATOR;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

