/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaConfigProperties {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<String, String> commonClientConfig;
    protected String defaultClientIdPrefix;

    public final void setCommonClientConfig(Map<String, String> commonClientConfig) {
        this.commonClientConfig = Objects.requireNonNull(commonClientConfig);
    }

    public final void setDefaultClientIdPrefix(String clientId) {
        this.defaultClientIdPrefix = Objects.requireNonNull(clientId);
    }

    protected final void overrideConfigProperty(Map<String, String> config, String key, String value) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.log.trace("setting Kafka config property [{}={}]", (Object)key, (Object)value);
        String oldValue = config.put(key, value);
        if (oldValue != null) {
            this.log.debug("provided Kafka configuration contains property [{}={}], changing it to [{}]", new Object[]{key, oldValue, value});
        }
    }

    protected final void setUniqueClientId(Map<String, String> config, String clientName, String clientIdPropertyName) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(clientName);
        Objects.requireNonNull(clientIdPropertyName);
        UUID uuid = UUID.randomUUID();
        String clientIdPrefix = Optional.ofNullable(config.get(clientIdPropertyName)).orElse(this.defaultClientIdPrefix);
        if (clientIdPrefix == null) {
            config.put(clientIdPropertyName, String.format("%s-%s", clientName, uuid));
        } else {
            config.put(clientIdPropertyName, String.format("%s-%s-%s", clientIdPrefix, clientName, uuid));
        }
    }
}

