/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.client.kafka.AbstractKafkaConfigProperties;

public class KafkaProducerConfigProperties
extends AbstractKafkaConfigProperties {
    private Map<String, String> producerConfig;

    public final void setProducerConfig(Map<String, String> producerConfig) {
        this.producerConfig = Objects.requireNonNull(producerConfig);
    }

    public final boolean isConfigured() {
        return this.commonClientConfig != null || this.producerConfig != null;
    }

    public final Map<String, String> getProducerConfig(String producerName) {
        Objects.requireNonNull(producerName);
        if (this.commonClientConfig == null && this.producerConfig == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> newConfig = new HashMap<String, String>();
        if (this.commonClientConfig != null) {
            newConfig.putAll(this.commonClientConfig);
        }
        if (this.producerConfig != null) {
            newConfig.putAll(this.producerConfig);
        }
        this.overrideConfigProperty(newConfig, "key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.overrideConfigProperty(newConfig, "value.serializer", "io.vertx.kafka.client.serialization.BufferSerializer");
        this.overrideConfigProperty(newConfig, "enable.idempotence", "true");
        this.setUniqueClientId(newConfig, producerName, "client.id");
        return newConfig;
    }
}

