/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.producer;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serializer;
import org.eclipse.hono.client.kafka.AbstractKafkaConfigProperties;
import org.eclipse.hono.client.kafka.CommonKafkaClientConfigProperties;
import org.eclipse.hono.client.kafka.CommonKafkaClientOptions;
import org.eclipse.hono.client.kafka.ConfigOptionsHelper;
import org.eclipse.hono.client.kafka.producer.KafkaProducerOptions;

public class KafkaProducerConfigProperties
extends AbstractKafkaConfigProperties {
    private final Class<? extends Serializer<?>> keySerializerClass;
    private final Class<? extends Serializer<?>> valueSerializerClass;

    protected KafkaProducerConfigProperties(Class<? extends Serializer<?>> keySerializerClass, Class<? extends Serializer<?>> valueSerializerClass) {
        this.keySerializerClass = keySerializerClass;
        this.valueSerializerClass = valueSerializerClass;
    }

    protected KafkaProducerConfigProperties(Class<? extends Serializer<?>> keySerializerClass, Class<? extends Serializer<?>> valueSerializerClass, CommonKafkaClientOptions commonOptions, KafkaProducerOptions options) {
        this.keySerializerClass = keySerializerClass;
        this.valueSerializerClass = valueSerializerClass;
        CommonKafkaClientConfigProperties commonConfig = new CommonKafkaClientConfigProperties(commonOptions);
        this.setCommonClientConfig(commonConfig);
        this.setSpecificClientConfig(ConfigOptionsHelper.toStringValueMap(options.producerConfig()));
    }

    public final void setProducerConfig(Map<String, String> producerConfig) {
        this.setSpecificClientConfig(producerConfig);
    }

    public final Map<String, String> getProducerConfig(String producerName) {
        Map<String, String> config = this.getConfig(producerName);
        this.adaptConfiguration(config);
        Optional.ofNullable(this.keySerializerClass).ifPresent(serializerClass -> this.overrideConfigProperty(config, "key.serializer", serializerClass.getName()));
        Optional.ofNullable(this.valueSerializerClass).ifPresent(serializerClass -> this.overrideConfigProperty(config, "value.serializer", serializerClass.getName()));
        return config;
    }

    protected void adaptConfiguration(Map<String, String> config) {
    }
}

