/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.Json;
import io.vertx.kafka.client.producer.KafkaHeader;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.util.QoS;

public final class KafkaRecordHelper {
    public static final String HEADER_RESPONSE_REQUIRED = "response-required";
    private static final String HEADER_ORIGINAL_PARTITION = "orig-partition";
    private static final String HEADER_ORIGINAL_OFFSET = "orig-offset";

    private KafkaRecordHelper() {
    }

    public static KafkaHeader createKafkaHeader(String key, Object value) throws EncodeException {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        String encodedValue = value instanceof String ? (String)value : Json.encode((Object)value);
        return KafkaHeader.header((String)key, (Buffer)Buffer.buffer((String)encodedValue));
    }

    public static Optional<String> getContentType(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "content-type", String.class);
    }

    public static Optional<QoS> getQoS(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "qos", Integer.class).map(integer -> Integer.valueOf(0).equals(integer) ? QoS.AT_MOST_ONCE : QoS.AT_LEAST_ONCE);
    }

    public static boolean isTtlElapsed(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "ttl", Long.class).map(ttl -> {
            Instant now = Instant.now();
            Instant elapseTime = KafkaRecordHelper.getCreationTime(headers).orElse(now).plus(Duration.ofMillis(ttl));
            return elapseTime.isBefore(now);
        }).orElse(Boolean.FALSE);
    }

    public static Optional<Instant> getCreationTime(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "creation-time", Long.class).map(Instant::ofEpochMilli);
    }

    public static Optional<String> getTenantId(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "tenant_id", String.class);
    }

    public static KafkaHeader createTenantIdHeader(String value) {
        return KafkaRecordHelper.createKafkaHeader("tenant_id", value);
    }

    public static Optional<String> getDeviceId(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "device_id", String.class);
    }

    public static KafkaHeader createDeviceIdHeader(String value) {
        return KafkaRecordHelper.createKafkaHeader("device_id", value);
    }

    public static Optional<String> getSubject(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "subject", String.class);
    }

    public static KafkaHeader createSubjectHeader(String value) {
        return KafkaRecordHelper.createKafkaHeader("subject", value);
    }

    public static Optional<String> getCorrelationId(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "correlation-id", String.class);
    }

    public static KafkaHeader createCorrelationIdHeader(String value) {
        return KafkaRecordHelper.createKafkaHeader("correlation-id", value);
    }

    public static Optional<String> getViaHeader(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, "via", String.class);
    }

    public static KafkaHeader createViaHeader(String value) {
        return KafkaRecordHelper.createKafkaHeader("via", value);
    }

    public static Optional<Integer> getOriginalPartitionHeader(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, HEADER_ORIGINAL_PARTITION, Integer.class);
    }

    public static KafkaHeader createOriginalPartitionHeader(int value) {
        return KafkaRecordHelper.createKafkaHeader(HEADER_ORIGINAL_PARTITION, value);
    }

    public static Optional<Long> getOriginalOffsetHeader(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, HEADER_ORIGINAL_OFFSET, Long.class);
    }

    public static KafkaHeader createOriginalOffsetHeader(long value) {
        return KafkaRecordHelper.createKafkaHeader(HEADER_ORIGINAL_OFFSET, value);
    }

    public static boolean isResponseRequired(List<KafkaHeader> headers) {
        return KafkaRecordHelper.getHeaderValue(headers, HEADER_RESPONSE_REQUIRED, Boolean.class).orElse(false);
    }

    public static KafkaHeader createResponseRequiredHeader(boolean value) {
        return KafkaRecordHelper.createKafkaHeader(HEADER_RESPONSE_REQUIRED, value);
    }

    public static <T> Optional<T> getHeaderValue(List<KafkaHeader> headers, String key, Class<T> type) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        if (headers == null) {
            return Optional.empty();
        }
        return headers.stream().filter(h -> key.equals(h.key())).findFirst().map(h -> KafkaRecordHelper.decode(h, type));
    }

    public static <T> T decode(KafkaHeader header, Class<T> type) {
        Objects.requireNonNull(type);
        if (header == null) {
            return null;
        }
        return KafkaRecordHelper.decode(header.value(), type);
    }

    public static <T> T decode(Buffer encodedHeaderValue, Class<T> type) {
        Objects.requireNonNull(type);
        if (encodedHeaderValue == null) {
            return null;
        }
        try {
            if (String.class.equals(type)) {
                return (T)encodedHeaderValue.toString();
            }
            return (T)Json.decodeValue((Buffer)encodedHeaderValue, type);
        }
        catch (DecodeException ex) {
            return null;
        }
    }
}

