/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.client.amqp.AbstractRequestResponseServiceClient;
import org.eclipse.hono.client.amqp.RequestResponseClient;
import org.eclipse.hono.client.command.DeviceConnectionClient;
import org.eclipse.hono.client.impl.CachingClientFactory;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.DeviceConnectionConstants;
import org.eclipse.hono.util.DeviceConnectionResult;
import org.eclipse.hono.util.RequestResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonBasedDeviceConnectionClient
extends AbstractRequestResponseServiceClient<JsonObject, DeviceConnectionResult>
implements DeviceConnectionClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedDeviceConnectionClient.class);

    public ProtonBasedDeviceConnectionClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory) {
        super(connection, samplerFactory, new CachingClientFactory(connection.getVertx(), RequestResponseClient::isOpen), null);
        connection.getVertx().eventBus().consumer("tenant.timeout", arg_0 -> ((ProtonBasedDeviceConnectionClient)this).handleTenantTimeout(arg_0));
    }

    protected String getKey(String tenantId) {
        return String.format("%s-%s", "device_con", tenantId);
    }

    private Future<RequestResponseClient<DeviceConnectionResult>> getOrCreateClient(String tenantId) {
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> this.clientFactory.getOrCreateClient(this.getKey(tenantId), () -> RequestResponseClient.forEndpoint((HonoConnection)this.connection, (String)"device_con", (String)tenantId, (SendMessageSampler)this.samplerFactory.create("device_con"), arg_0 -> ((ProtonBasedDeviceConnectionClient)this).removeClient(arg_0), arg_0 -> ((ProtonBasedDeviceConnectionClient)this).removeClient(arg_0)), (Handler)result)));
    }

    protected final DeviceConnectionResult getResult(int status, String contentType, Buffer payload, CacheDirective cacheDirective, ApplicationProperties applicationProperties) {
        if (payload == null) {
            return DeviceConnectionResult.from((int)status, null, null, (ApplicationProperties)applicationProperties);
        }
        try {
            return DeviceConnectionResult.from((int)status, (JsonObject)new JsonObject(payload), (CacheDirective)CacheDirective.noCacheDirective(), (ApplicationProperties)applicationProperties);
        }
        catch (DecodeException e) {
            LOG.warn("received malformed payload from Device Connection service", (Throwable)e);
            return DeviceConnectionResult.from((int)500, null, null, (ApplicationProperties)applicationProperties);
        }
    }

    public Future<JsonObject> getLastKnownGatewayForDevice(String tenant, String deviceId, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Span currentSpan = this.newChildSpan(context, "get last known gateway for device");
        TracingHelper.setDeviceTags((Span)currentSpan, (String)tenant, (String)deviceId);
        Future resultTracker = this.getOrCreateClient(tenant).compose(client -> client.createAndSendRequest(DeviceConnectionConstants.DeviceConnectionAction.GET_LAST_GATEWAY.getSubject(), this.createDeviceIdProperties(deviceId), null, null, arg_0 -> ((ProtonBasedDeviceConnectionClient)this).getRequestResponseResult(arg_0), currentSpan));
        return this.mapResultAndFinishSpan(resultTracker, result -> {
            switch (result.getStatus()) {
                case 200: {
                    return (JsonObject)result.getPayload();
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)result);
        }, currentSpan);
    }

    public Future<Void> setLastKnownGatewayForDevice(String tenant, String deviceId, String gatewayId, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Map properties = this.createDeviceIdProperties(deviceId);
        properties.put("gateway_id", gatewayId);
        Span currentSpan = this.newFollowingSpan(context, "set last known gateway for device");
        TracingHelper.setDeviceTags((Span)currentSpan, (String)tenant, (String)deviceId);
        currentSpan.setTag("gateway_id", gatewayId);
        Future resultTracker = this.getOrCreateClient(tenant).compose(client -> client.createAndSendRequest(DeviceConnectionConstants.DeviceConnectionAction.SET_LAST_GATEWAY.getSubject(), properties, null, null, arg_0 -> ((ProtonBasedDeviceConnectionClient)this).getRequestResponseResult(arg_0), currentSpan));
        return this.mapResultAndFinishSpan(resultTracker, result -> {
            switch (result.getStatus()) {
                case 204: {
                    return null;
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)result);
        }, currentSpan).mapEmpty();
    }

    public Future<Void> setCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, Duration lifespan, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(adapterInstanceId);
        int lifespanSeconds = lifespan != null && lifespan.getSeconds() <= Integer.MAX_VALUE ? (int)lifespan.getSeconds() : -1;
        Map properties = this.createDeviceIdProperties(deviceId);
        properties.put("adapter_instance_id", adapterInstanceId);
        properties.put("lifespan", lifespanSeconds);
        Span currentSpan = this.newChildSpan(context, "set command handling adapter instance");
        TracingHelper.setDeviceTags((Span)currentSpan, (String)tenantId, (String)deviceId);
        currentSpan.setTag("adapter_instance_id", adapterInstanceId);
        currentSpan.setTag("lifespan", (Number)lifespanSeconds);
        Future resultTracker = this.getOrCreateClient(tenantId).compose(client -> client.createAndSendRequest(DeviceConnectionConstants.DeviceConnectionAction.SET_CMD_HANDLING_ADAPTER_INSTANCE.getSubject(), properties, null, null, arg_0 -> ((ProtonBasedDeviceConnectionClient)this).getRequestResponseResult(arg_0), currentSpan));
        return this.mapResultAndFinishSpan(resultTracker, result -> {
            switch (result.getStatus()) {
                case 204: {
                    return null;
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)result);
        }, currentSpan).mapEmpty();
    }

    public Future<Void> removeCommandHandlingAdapterInstance(String tenantId, String deviceId, String adapterInstanceId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(adapterInstanceId);
        Map properties = this.createDeviceIdProperties(deviceId);
        properties.put("adapter_instance_id", adapterInstanceId);
        Span currentSpan = this.newChildSpan(context, "remove command handling adapter instance");
        TracingHelper.setDeviceTags((Span)currentSpan, (String)tenantId, (String)deviceId);
        currentSpan.setTag("adapter_instance_id", adapterInstanceId);
        return this.getOrCreateClient(tenantId).compose(client -> client.createAndSendRequest(DeviceConnectionConstants.DeviceConnectionAction.REMOVE_CMD_HANDLING_ADAPTER_INSTANCE.getSubject(), properties, null, null, arg_0 -> ((ProtonBasedDeviceConnectionClient)this).getRequestResponseResult(arg_0), currentSpan)).recover(t -> {
            Tags.HTTP_STATUS.set(currentSpan, Integer.valueOf(ServiceInvocationException.extractStatusCode((Throwable)t)));
            TracingHelper.logError((Span)currentSpan, (Throwable)t);
            return Future.failedFuture((Throwable)t);
        }).map(resultValue -> {
            Tags.HTTP_STATUS.set(currentSpan, Integer.valueOf(resultValue.getStatus()));
            if (resultValue.isError() && resultValue.getStatus() != 412) {
                Tags.ERROR.set(currentSpan, Boolean.TRUE);
            }
            switch (resultValue.getStatus()) {
                case 204: {
                    return null;
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)resultValue);
        }).onComplete(v -> currentSpan.finish()).mapEmpty();
    }

    public Future<JsonObject> getCommandHandlingAdapterInstances(String tenant, String deviceId, List<String> viaGateways, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(viaGateways);
        Map properties = this.createDeviceIdProperties(deviceId);
        JsonObject payload = new JsonObject();
        payload.put("gateway-ids", new JsonArray(viaGateways));
        Span currentSpan = this.newChildSpan(context, "get command handling adapter instances");
        TracingHelper.setDeviceTags((Span)currentSpan, (String)tenant, (String)deviceId);
        Future resultTracker = this.getOrCreateClient(tenant).compose(client -> client.createAndSendRequest(DeviceConnectionConstants.DeviceConnectionAction.GET_CMD_HANDLING_ADAPTER_INSTANCES.getSubject(), properties, payload.toBuffer(), "application/json", arg_0 -> ((ProtonBasedDeviceConnectionClient)this).getRequestResponseResult(arg_0), currentSpan));
        return this.mapResultAndFinishSpan(resultTracker, result -> {
            switch (result.getStatus()) {
                case 200: {
                    return (JsonObject)result.getPayload();
                }
            }
            throw StatusCodeMapper.from((RequestResponseResult)result);
        }, currentSpan);
    }
}

