/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.CommandTargetMapper;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.ProtocolAdapterCommandConsumer;
import org.eclipse.hono.client.ProtocolAdapterCommandConsumerFactory;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.amqp.AbstractServiceClient;
import org.eclipse.hono.client.command.CommandConsumer;
import org.eclipse.hono.client.command.CommandConsumerFactory;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.DeviceConnectionClient;
import org.eclipse.hono.client.command.amqp.ProtonBasedLegacyCommandContextWrapper;
import org.eclipse.hono.client.registry.DeviceRegistrationClient;
import org.eclipse.hono.util.RegistrationAssertion;

public class ProtonBasedDelegatingCommandConsumerFactory
extends AbstractServiceClient
implements CommandConsumerFactory {
    private final ProtocolAdapterCommandConsumerFactory factory;
    private final CommandTargetMapper commandTargetMapper;
    private final DeviceConnectionClient deviceConnectionClient;

    public ProtonBasedDelegatingCommandConsumerFactory(HonoConnection connection, SendMessageSampler.Factory samplerFactory, final DeviceConnectionClient deviceConnectionClient, final DeviceRegistrationClient deviceRegistrationClient, Tracer tracer) {
        super(connection, samplerFactory);
        this.deviceConnectionClient = Objects.requireNonNull(deviceConnectionClient);
        Objects.requireNonNull(deviceRegistrationClient);
        Objects.requireNonNull(tracer);
        this.commandTargetMapper = CommandTargetMapper.create((Tracer)tracer);
        this.commandTargetMapper.initialize(new CommandTargetMapper.CommandTargetMapperContext(){

            public Future<List<String>> getViaGateways(String tenant, String deviceId, SpanContext context) {
                Objects.requireNonNull(tenant);
                Objects.requireNonNull(deviceId);
                return deviceRegistrationClient.assertRegistration(tenant, deviceId, null, context).map(RegistrationAssertion::getAuthorizedGateways);
            }

            public Future<JsonObject> getCommandHandlingAdapterInstances(String tenant, String deviceId, List<String> viaGateways, SpanContext context) {
                Objects.requireNonNull(tenant);
                Objects.requireNonNull(deviceId);
                Objects.requireNonNull(viaGateways);
                return deviceConnectionClient.getCommandHandlingAdapterInstances(tenant, deviceId, viaGateways, context);
            }
        });
        this.factory = ProtocolAdapterCommandConsumerFactory.create((HonoConnection)connection, (SendMessageSampler.Factory)samplerFactory);
    }

    public Future<CommandConsumer> createCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandHandler, Duration lifespan, SpanContext context) {
        return this.factory.createCommandConsumer(tenantId, deviceId, ctx -> commandHandler.handle((Object)new ProtonBasedLegacyCommandContextWrapper((org.eclipse.hono.client.CommandContext)ctx)), lifespan, context).map(adapterCommandConsumer -> new CommandConsumer((ProtocolAdapterCommandConsumer)adapterCommandConsumer){
            final /* synthetic */ ProtocolAdapterCommandConsumer val$adapterCommandConsumer;
            {
                this.val$adapterCommandConsumer = protocolAdapterCommandConsumer;
            }

            public Future<Void> close(SpanContext spanContext) {
                return this.val$adapterCommandConsumer.close(spanContext);
            }
        });
    }

    public Future<CommandConsumer> createCommandConsumer(String tenantId, String deviceId, String gatewayId, Handler<CommandContext> commandHandler, Duration lifespan, SpanContext context) {
        return this.factory.createCommandConsumer(tenantId, deviceId, gatewayId, ctx -> commandHandler.handle((Object)new ProtonBasedLegacyCommandContextWrapper((org.eclipse.hono.client.CommandContext)ctx)), lifespan, context).map(adapterCommandConsumer -> new CommandConsumer((ProtocolAdapterCommandConsumer)adapterCommandConsumer){
            final /* synthetic */ ProtocolAdapterCommandConsumer val$adapterCommandConsumer;
            {
                this.val$adapterCommandConsumer = protocolAdapterCommandConsumer;
            }

            public Future<Void> close(SpanContext spanContext) {
                return this.val$adapterCommandConsumer.close(spanContext);
            }
        });
    }

    public Future<Void> start() {
        return this.connection.connect().onSuccess(ok -> this.log.info("connection to {} endpoint has been established", (Object)this.connection.getConfig().getServerRole())).onFailure(t -> this.log.warn("failed to establish connection to {} endpoint", (Object)this.connection.getConfig().getServerRole(), t)).onComplete(ar -> this.factory.initialize(this.commandTargetMapper, new ProtocolAdapterCommandConsumerFactory.CommandHandlingAdapterInfoAccess(){

            public Future<Void> setCommandHandlingAdapterInstance(String tenant, String deviceId, String adapterInstanceId, Duration lifespan, SpanContext context) {
                return ProtonBasedDelegatingCommandConsumerFactory.this.deviceConnectionClient.setCommandHandlingAdapterInstance(tenant, deviceId, adapterInstanceId, lifespan, context);
            }

            public Future<Void> removeCommandHandlingAdapterInstance(String tenant, String deviceId, String adapterInstanceId, SpanContext context) {
                return ProtonBasedDelegatingCommandConsumerFactory.this.deviceConnectionClient.removeCommandHandlingAdapterInstance(tenant, deviceId, adapterInstanceId, context);
            }
        })).mapEmpty();
    }
}

