/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.application.client.MessageProperties;
import org.eclipse.hono.client.kafka.KafkaRecordHelper;

public class KafkaMessageProperties
implements MessageProperties {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public KafkaMessageProperties(KafkaConsumerRecord<String, Buffer> record) {
        Objects.requireNonNull(record);
        record.headers().forEach(header -> this.properties.put(header.key(), header.value()));
    }

    public final Map<String, Object> getPropertiesMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public final <T> T getProperty(String name, Class<T> type) {
        return Optional.ofNullable(this.properties.get(name)).filter(Buffer.class::isInstance).map(Buffer.class::cast).map(value -> KafkaRecordHelper.decode((Buffer)value, (Class)type)).orElse(null);
    }
}

