/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonHelper;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.application.client.CommandSender;
import org.eclipse.hono.application.client.amqp.ProtonBasedRequestResponseCommandClient;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.client.amqp.SenderCachingServiceClient;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.AddressHelper;
import org.eclipse.hono.util.BufferResult;
import org.eclipse.hono.util.MessageHelper;

public class ProtonBasedCommandSender
extends SenderCachingServiceClient
implements CommandSender {
    private final ProtonBasedRequestResponseCommandClient requestResponseClient;

    public ProtonBasedCommandSender(HonoConnection connection, SendMessageSampler.Factory samplerFactory) {
        super(connection, samplerFactory);
        this.requestResponseClient = new ProtonBasedRequestResponseCommandClient(connection, samplerFactory);
    }

    public Future<Void> sendAsyncCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, String replyId, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        Objects.requireNonNull(correlationId);
        Objects.requireNonNull(replyId);
        return this.sendCommand(tenantId, deviceId, command, contentType, data, correlationId, replyId, properties, this.newChildSpan(context, "send command"));
    }

    public Future<Void> sendOneWayCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        return this.sendCommand(tenantId, deviceId, command, contentType, data, null, null, properties, this.newChildSpan(context, "send one-way command"));
    }

    public Future<BufferResult> sendCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String replyId, Map<String, Object> properties, SpanContext context) {
        return this.requestResponseClient.sendCommand(tenantId, deviceId, command, contentType, data, replyId, properties, context);
    }

    private Future<Void> sendCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, String replyId, Map<String, Object> properties, Span span) {
        return this.getOrCreateSenderLink("command", tenantId).recover(thr -> Future.failedFuture((Throwable)StatusCodeMapper.toServerError((Throwable)thr))).compose(sender -> {
            String targetAddress = AddressHelper.getTargetAddress((String)"command", (String)tenantId, (String)deviceId, (ClientConfigProperties)this.connection.getConfig());
            Message msg = ProtonBasedCommandSender.createMessage(tenantId, deviceId, command, contentType, data, correlationId, replyId, targetAddress, properties);
            return sender.sendAndWaitForOutcome(msg, span);
        }).mapEmpty();
    }

    private static Message createMessage(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, String replyId, String targetAddress, Map<String, Object> properties) {
        Message msg = ProtonHelper.message();
        MessageHelper.setCreationTime((Message)msg);
        msg.setAddress(targetAddress);
        Optional.ofNullable(replyId).ifPresent(id -> msg.setReplyTo(String.format("%s/%s/%s", "command_response", tenantId, id)));
        Optional.ofNullable(correlationId).ifPresent(arg_0 -> ((Message)msg).setCorrelationId(arg_0));
        MessageHelper.setApplicationProperties((Message)msg, properties);
        msg.setSubject(command);
        MessageHelper.setPayload((Message)msg, (String)contentType, (Buffer)data);
        MessageHelper.addTenantId((Message)msg, (String)tenantId);
        MessageHelper.addDeviceId((Message)msg, (String)deviceId);
        return msg;
    }
}

