/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.config;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hono.client.amqp.config.AuthenticatingClientConfigProperties;
import org.eclipse.hono.client.amqp.config.ClientOptions;
import org.eclipse.hono.util.Strings;

public class ClientConfigProperties
extends AuthenticatingClientConfigProperties {
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    public static final long DEFAULT_FLOW_LATENCY = 20L;
    public static final int DEFAULT_IDLE_TIMEOUT = 16000;
    public static final int DEFAULT_INITIAL_CREDITS = 200;
    public static final long DEFAULT_LINK_ESTABLISHMENT_TIMEOUT = 1000L;
    public static final int DEFAULT_RECONNECT_MIN_DELAY = 0;
    public static final int DEFAULT_RECONNECT_MAX_DELAY = 7000;
    public static final int DEFAULT_RECONNECT_DELAY_INCREMENT = 100;
    public static final long DEFAULT_REQUEST_TIMEOUT = 200L;
    public static final long DEFAULT_SEND_MESSAGE_TIMEOUT = 1000L;
    public static final int MAX_FRAME_SIZE_UNLIMITED = -1;
    public static final long MAX_MESSAGE_SIZE_UNLIMITED = -1L;
    public static final int MAX_SESSION_FRAMES_UNLIMITED = -1;
    public static final long MIN_MAX_MESSAGE_SIZE_NONE = 0L;
    private Pattern addressRewritePattern;
    private String addressRewriteReplacement;
    private String addressRewriteRule = null;
    private String amqpHostname = null;
    private int connectTimeout = 5000;
    private long flowLatency = 20L;
    private int idleTimeout = 16000;
    private int initialCredits = 200;
    private long linkEstablishmentTimeout = 1000L;
    private int maxFrameSize = -1;
    private long maxMessageSize = -1L;
    private int maxSessionFrames = -1;
    private long minMaxMessageSize = 0L;
    private String name = null;
    private int reconnectAttempts = -1;
    private long reconnectMinDelay = 0L;
    private long reconnectMaxDelay = 7000L;
    private long reconnectDelayIncrement = 100L;
    private long requestTimeout = 200L;
    private long sendMessageTimeout = 1000L;

    public ClientConfigProperties() {
        this.setPort(5671);
    }

    public ClientConfigProperties(ClientConfigProperties otherProperties) {
        super(otherProperties);
        this.addressRewritePattern = otherProperties.addressRewritePattern;
        this.addressRewriteReplacement = otherProperties.addressRewriteReplacement;
        this.addressRewriteRule = otherProperties.addressRewriteRule;
        this.amqpHostname = otherProperties.amqpHostname;
        this.connectTimeout = otherProperties.connectTimeout;
        this.flowLatency = otherProperties.flowLatency;
        this.idleTimeout = otherProperties.idleTimeout;
        this.initialCredits = otherProperties.initialCredits;
        this.linkEstablishmentTimeout = otherProperties.linkEstablishmentTimeout;
        this.maxFrameSize = otherProperties.maxFrameSize;
        this.maxMessageSize = otherProperties.maxMessageSize;
        this.maxSessionFrames = otherProperties.maxSessionFrames;
        this.minMaxMessageSize = otherProperties.minMaxMessageSize;
        this.name = otherProperties.name;
        this.reconnectAttempts = otherProperties.reconnectAttempts;
        this.reconnectMinDelay = otherProperties.reconnectMinDelay;
        this.reconnectMaxDelay = otherProperties.reconnectMaxDelay;
        this.reconnectDelayIncrement = otherProperties.reconnectDelayIncrement;
        this.requestTimeout = otherProperties.requestTimeout;
        this.sendMessageTimeout = otherProperties.sendMessageTimeout;
    }

    public ClientConfigProperties(ClientOptions options) {
        super(options.authenticatingClientOptions());
        this.setAddressRewriteRule(options.addressRewriteRule().orElse(null));
        this.setAmqpHostname(options.amqpHostname().orElse(null));
        this.setConnectTimeout(options.connectTimeout());
        this.setFlowLatency(options.flowLatency());
        this.setIdleTimeout(options.idleTimeout());
        this.setInitialCredits(options.initialCredits());
        this.setLinkEstablishmentTimeout(options.linkEstablishmentTimeout());
        this.setMaxFrameSize(options.maxFrameSize());
        this.setMaxMessageSize(options.maxMessageSize());
        this.setMaxSessionFrames(options.maxSessionFrames());
        this.setMinMaxMessageSize(options.minMaxMessageSize());
        this.setName(options.name().orElse(null));
        this.setReconnectAttempts(options.reconnectAttempts());
        this.setReconnectMinDelay(options.reconnectMinDelay());
        this.setReconnectMaxDelay(options.reconnectMaxDelay());
        this.setReconnectDelayIncrement(options.reconnectDelayIncrement());
        this.setRequestTimeout(options.requestTimeout());
        this.setSendMessageTimeout(options.sendMessageTimeout());
    }

    public final String getName() {
        return this.name;
    }

    public final void setNameIfNotSet(String defaultName) {
        Objects.requireNonNull(defaultName);
        if (Strings.isNullOrEmpty((Object)this.name)) {
            this.setName(defaultName);
        }
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getAmqpHostname() {
        return this.amqpHostname;
    }

    public final void setAmqpHostname(String amqpHostname) {
        this.amqpHostname = amqpHostname;
    }

    public final long getFlowLatency() {
        return this.flowLatency;
    }

    public final void setFlowLatency(long latency) {
        if (latency < 0L) {
            throw new IllegalArgumentException("latency must not be negative");
        }
        this.flowLatency = latency;
    }

    public final long getLinkEstablishmentTimeout() {
        return this.linkEstablishmentTimeout;
    }

    public final void setLinkEstablishmentTimeout(long latency) {
        if (latency < 0L) {
            throw new IllegalArgumentException("latency must not be negative");
        }
        this.linkEstablishmentTimeout = latency;
    }

    public final int getInitialCredits() {
        return this.initialCredits;
    }

    public final void setInitialCredits(int initialCredits) {
        if (initialCredits < 0) {
            throw new IllegalArgumentException("initial credits must not be negative");
        }
        this.initialCredits = initialCredits;
    }

    public final long getSendMessageTimeout() {
        return this.sendMessageTimeout;
    }

    public final void setSendMessageTimeout(long sendMessageTimeoutMillis) {
        if (sendMessageTimeoutMillis < 0L) {
            throw new IllegalArgumentException("sendMessageTimeout must not be negative");
        }
        this.sendMessageTimeout = sendMessageTimeoutMillis;
    }

    public final long getRequestTimeout() {
        return this.requestTimeout;
    }

    public final void setRequestTimeout(long requestTimeoutMillis) {
        if (requestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("request timeout must not be negative");
        }
        this.requestTimeout = requestTimeoutMillis;
    }

    public final int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public final void setReconnectAttempts(int attempts) {
        if (attempts < -1) {
            throw new IllegalArgumentException("attempts must be >= -1");
        }
        this.reconnectAttempts = attempts;
    }

    public final long getReconnectMinDelay() {
        return this.reconnectMinDelay;
    }

    public final void setReconnectMinDelay(long reconnectMinDelay) {
        if (reconnectMinDelay < 0L) {
            throw new IllegalArgumentException("minimum delay must be >= 0");
        }
        this.reconnectMinDelay = reconnectMinDelay;
    }

    public final long getReconnectMaxDelay() {
        return this.reconnectMaxDelay;
    }

    public final void setReconnectMaxDelay(long reconnectMaxDelay) {
        if (reconnectMaxDelay < 0L) {
            throw new IllegalArgumentException("maximum delay must be >= 0");
        }
        this.reconnectMaxDelay = reconnectMaxDelay;
    }

    public final long getReconnectDelayIncrement() {
        return this.reconnectDelayIncrement;
    }

    public final void setReconnectDelayIncrement(long reconnectDelayIncrement) {
        if (reconnectDelayIncrement < 0L) {
            throw new IllegalArgumentException("value must be >= 0");
        }
        this.reconnectDelayIncrement = reconnectDelayIncrement;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int connectTimeoutMillis) {
        if (connectTimeoutMillis < 0) {
            throw new IllegalArgumentException("connect timeout must not be negative");
        }
        this.connectTimeout = connectTimeoutMillis;
    }

    public final int getCloseConnectionTimeout() {
        int connectTimeoutToUse = this.connectTimeout > 0 ? this.connectTimeout : 5000;
        return connectTimeoutToUse / 2;
    }

    public final int getHeartbeatInterval() {
        return this.idleTimeout / 2;
    }

    public final int getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(int idleTimeoutMillis) {
        if (idleTimeoutMillis < 0) {
            throw new IllegalArgumentException("idleTimeout must not be negative");
        }
        this.idleTimeout = idleTimeoutMillis;
    }

    public final String getAddressRewriteRule() {
        return this.addressRewriteRule;
    }

    public final void setAddressRewriteRule(String addressRewriteRule) {
        String[] elements;
        this.addressRewriteRule = addressRewriteRule;
        if (!Strings.isNullOrEmpty((Object)addressRewriteRule) && (elements = addressRewriteRule.split(" ", 2)).length == 2) {
            try {
                this.addressRewritePattern = Pattern.compile(elements[0]);
                this.addressRewriteReplacement = elements[1];
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public final Pattern getAddressRewritePattern() {
        return this.addressRewritePattern;
    }

    public final String getAddressRewriteReplacement() {
        return this.addressRewriteReplacement;
    }

    public final long getMinMaxMessageSize() {
        return this.minMaxMessageSize;
    }

    public final void setMinMaxMessageSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("min message size must be >= 0");
        }
        this.minMaxMessageSize = size;
    }

    public final long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public final void setMaxMessageSize(long size) {
        if (size < -1L) {
            throw new IllegalArgumentException("max-message-size must be >= -1");
        }
        this.maxMessageSize = size;
    }

    public final int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public final void setMaxFrameSize(int maxFrameSize) {
        if (maxFrameSize != -1 && maxFrameSize < 512) {
            throw new IllegalArgumentException("frame size must be at least 512 bytes");
        }
        this.maxFrameSize = maxFrameSize;
    }

    public final int getMaxSessionFrames() {
        return this.maxSessionFrames;
    }

    public final void setMaxSessionFrames(int maxSessionFrames) {
        if (maxSessionFrames != -1 && maxSessionFrames < 1) {
            throw new IllegalArgumentException("must support at least one frame being in flight");
        }
        this.maxSessionFrames = maxSessionFrames;
    }

    public final int getMaxSessionWindowSize() {
        if (this.maxSessionFrames != -1 && this.maxFrameSize != -1) {
            return this.maxSessionFrames * this.maxFrameSize;
        }
        return 0;
    }
}

