/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.tracing;

import io.opentracing.propagation.TextMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAnnotationsExtractAdapter
implements TextMap {
    private static final Logger LOG = LoggerFactory.getLogger(MessageAnnotationsExtractAdapter.class);
    private final Message message;
    private final String propertiesMapName;

    public MessageAnnotationsExtractAdapter(Message message, String propertiesMapName) {
        this.message = Objects.requireNonNull(message);
        this.propertiesMapName = Objects.requireNonNull(propertiesMapName);
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        Map<?, ?> propertiesMap = this.getPropertiesMap();
        if (propertiesMap.isEmpty()) {
            return Collections.emptyIterator();
        }
        final Iterator<Map.Entry<?, ?>> entriesIterator = propertiesMap.entrySet().iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return entriesIterator.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                Map.Entry nextEntry = (Map.Entry)entriesIterator.next();
                return new AbstractMap.SimpleEntry<String, String>(nextEntry.getKey().toString(), nextEntry.getValue().toString());
            }
        };
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    private Map<?, ?> getPropertiesMap() {
        MessageAnnotations messageAnnotations = this.message.getMessageAnnotations();
        if (messageAnnotations == null || messageAnnotations.getValue() == null) {
            return Collections.emptyMap();
        }
        Object annotationValue = messageAnnotations.getValue().get(Symbol.getSymbol((String)this.propertiesMapName));
        if (!(annotationValue instanceof Map)) {
            if (annotationValue != null) {
                LOG.debug("Value of '{}' annotation is not of type Map; actual type: {}", (Object)this.propertiesMapName, (Object)annotationValue.getClass().getName());
            }
            return Collections.emptyMap();
        }
        return (Map)annotationValue;
    }
}

