/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.amqp.AbstractServiceClient;
import org.eclipse.hono.client.amqp.GenericSenderLink;
import org.eclipse.hono.client.amqp.config.AddressHelper;
import org.eclipse.hono.client.amqp.config.ClientConfigProperties;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.util.CachingClientFactory;

public abstract class SenderCachingServiceClient
extends AbstractServiceClient {
    private final CachingClientFactory<GenericSenderLink> clientFactory;

    protected SenderCachingServiceClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory) {
        this(connection, samplerFactory, true);
    }

    protected SenderCachingServiceClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory, boolean isTenantSpecificLink) {
        super(connection, samplerFactory);
        this.clientFactory = new CachingClientFactory(connection.getVertx(), GenericSenderLink::isOpen);
        if (isTenantSpecificLink) {
            connection.getVertx().eventBus().consumer("tenant.timeout", this::handleTenantTimeout);
        }
    }

    private void handleTenantTimeout(Message<String> msg) {
        String tenantId = (String)msg.body();
        List.of(AddressHelper.getTargetAddress((String)"telemetry", (String)tenantId, null, (ClientConfigProperties)this.connection.getConfig()), AddressHelper.getTargetAddress((String)"event", (String)tenantId, null, (ClientConfigProperties)this.connection.getConfig())).forEach(key -> Optional.ofNullable((GenericSenderLink)this.clientFactory.getClient(key)).ifPresent(client -> client.close().onComplete(r -> this.clientFactory.removeClient(key))));
    }

    @Override
    protected void onDisconnect() {
        this.clientFactory.onDisconnect();
    }

    protected final Future<GenericSenderLink> getOrCreateSenderLink(String endpoint, String tenantId) {
        Objects.requireNonNull(endpoint);
        Objects.requireNonNull(tenantId);
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> {
            String key = AddressHelper.getTargetAddress((String)endpoint, (String)tenantId, null, (ClientConfigProperties)this.connection.getConfig());
            this.clientFactory.getOrCreateClient(key, () -> GenericSenderLink.create(this.connection, endpoint, tenantId, this.samplerFactory.create(endpoint), (Handler<String>)((Handler)onSenderClosed -> this.removeClient(key))), (Handler)result);
        }));
    }

    protected final Future<GenericSenderLink> getOrCreateSenderLink(String address) {
        Objects.requireNonNull(address);
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> {
            String key = AddressHelper.rewrite((String)address, (ClientConfigProperties)this.connection.getConfig());
            this.clientFactory.getOrCreateClient(key, () -> GenericSenderLink.create(this.connection, address, (Handler<String>)((Handler)onSenderClosed -> this.removeClient(key))), (Handler)result);
        }));
    }

    protected final void removeClient(String key) {
        this.clientFactory.removeClient(key);
    }
}

