/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHonoClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHonoClient.class);
    protected final HonoConnection connection;
    protected ProtonSender sender;
    protected ProtonReceiver receiver;
    protected List<Symbol> offeredCapabilities = Collections.emptyList();

    protected AbstractHonoClient(HonoConnection connection) {
        this.connection = Objects.requireNonNull(connection);
    }

    protected final void logError(Span span, Throwable error) {
        if (span != null) {
            if (ServiceInvocationException.class.isInstance(error)) {
                ServiceInvocationException e = (ServiceInvocationException)error;
                Tags.HTTP_STATUS.set(span, Integer.valueOf(e.getErrorCode()));
            }
            TracingHelper.logError((Span)span, (Throwable)error);
        }
    }

    public final boolean supportsCapability(Symbol capability) {
        if (capability == null) {
            return false;
        }
        return this.offeredCapabilities.contains(capability);
    }

    protected final Future<Void> closeLinks() {
        Promise result = Promise.promise();
        Handler closeReceiver = s -> {
            if (this.receiver != null) {
                LOG.debug("locally closing receiver link [{}]", (Object)this.receiver.getSource().getAddress());
            }
            this.connection.closeAndFree((ProtonLink)this.receiver, receiverClosed -> result.complete());
        };
        if (this.sender != null) {
            LOG.debug("locally closing sender link [{}]", (Object)this.sender.getTarget().getAddress());
            this.connection.closeAndFree((ProtonLink)this.sender, senderClosed -> closeReceiver.handle(null));
        } else if (this.receiver != null) {
            closeReceiver.handle(null);
        } else {
            result.complete();
        }
        return result.future();
    }

    protected static final void setApplicationProperties(Message msg, Map<String, ?> properties) {
        if (properties != null) {
            HashMap propsToAdd = new HashMap();
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                if (entry.getValue() != null) {
                    if (entry.getValue() instanceof List) {
                        throw new IllegalArgumentException(String.format("Application property %s can't be a List", entry.getKey()));
                    }
                    if (entry.getValue() instanceof Map) {
                        throw new IllegalArgumentException(String.format("Application property %s can't be a Map", entry.getKey()));
                    }
                    if (entry.getValue().getClass().isArray()) {
                        throw new IllegalArgumentException(String.format("Application property %s can't be an Array", entry.getKey()));
                    }
                }
                propsToAdd.put(entry.getKey(), entry.getValue());
            }
            ApplicationProperties applicationProperties = new ApplicationProperties(propsToAdd);
            msg.setApplicationProperties(applicationProperties);
        }
    }
}

