/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp;

import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.util.DownstreamMessageProperties;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.ResourceLimits;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownstreamAmqpMessageFactory {
    public static final String JMS_VENDOR_PROPERTY_CONTENT_ENCODING = "JMS_AMQP_CONTENT_ENCODING";
    public static final String JMS_VENDOR_PROPERTY_CONTENT_TYPE = "JMS_AMQP_CONTENT_TYPE";
    private static final Logger LOG = LoggerFactory.getLogger(DownstreamAmqpMessageFactory.class);

    private DownstreamAmqpMessageFactory() {
    }

    public static Message newMessage(ResourceIdentifier target, String contentType, Buffer payload, TenantObject tenant, Map<String, Object> tenantLevelDefaults, Map<String, Object> deviceLevelDefaults, Map<String, Object> messageProperties, boolean addJmsVendorProps) {
        Objects.requireNonNull(target);
        Message message = ProtonHelper.message();
        MessageHelper.setCreationTime((Message)message);
        message.setAddress(target.getBasePath());
        MessageHelper.annotate((Message)message, (ResourceIdentifier)target);
        Optional.ofNullable(payload).map(Buffer::getBytes).map(Binary::new).map(Data::new).ifPresent(arg_0 -> ((Message)message).setBody(arg_0));
        Map effectiveMessageProperties = Optional.ofNullable(messageProperties).map(HashMap::new).orElseGet(HashMap::new);
        Optional.ofNullable(contentType).ifPresent(ct -> effectiveMessageProperties.put("content-type", ct));
        DownstreamMessageProperties props = new DownstreamMessageProperties(target.getEndpoint(), tenantLevelDefaults, deviceLevelDefaults, effectiveMessageProperties, (ResourceLimits)Optional.ofNullable(tenant).map(TenantObject::getResourceLimits).orElse(null));
        DownstreamAmqpMessageFactory.addDefaults(message, props.asMap());
        if (Strings.isNullOrEmpty((Object)message.getContentType()) && message.getBody() != null) {
            message.setContentType("application/octet-stream");
        }
        if (addJmsVendorProps) {
            DownstreamAmqpMessageFactory.addJmsVendorProperties(message);
        }
        return message;
    }

    public static void addJmsVendorProperties(Message msg) {
        if (!Strings.isNullOrEmpty((Object)msg.getContentType())) {
            MessageHelper.addProperty((Message)msg, (String)JMS_VENDOR_PROPERTY_CONTENT_TYPE, (Object)msg.getContentType());
        }
        if (!Strings.isNullOrEmpty((Object)msg.getContentEncoding())) {
            MessageHelper.addProperty((Message)msg, (String)JMS_VENDOR_PROPERTY_CONTENT_ENCODING, (Object)msg.getContentEncoding());
        }
    }

    public static Message addDefaults(Message message, Map<String, Object> properties) {
        Objects.requireNonNull(message);
        if (properties == null) {
            return message;
        }
        properties.entrySet().forEach(prop -> {
            switch ((String)prop.getKey()) {
                case "x-opt-retain": {
                    MessageHelper.addAnnotation((Message)message, (String)((String)prop.getKey()), prop.getValue());
                    break;
                }
                case "ttl": {
                    if (!Number.class.isInstance(prop.getValue())) break;
                    message.setTtl(((Number)prop.getValue()).longValue());
                    break;
                }
                case "content-type": {
                    if (!String.class.isInstance(prop.getValue())) break;
                    message.setContentType((String)prop.getValue());
                    break;
                }
                case "content-encoding": {
                    if (!String.class.isInstance(prop.getValue())) break;
                    message.setContentEncoding((String)prop.getValue());
                    break;
                }
                case "delivery-count": 
                case "durable": 
                case "first-acquirer": 
                case "priority": 
                case "absolute-expiry-time": 
                case "correlation-id": 
                case "creation-time": 
                case "group-id": 
                case "group-sequence": 
                case "message-id": 
                case "reply-to": 
                case "reply-to-group-id": 
                case "subject": 
                case "to": 
                case "user-id": {
                    LOG.debug("ignoring default property [{}] registered for device", prop.getKey());
                    break;
                }
                default: {
                    MessageHelper.addProperty((Message)message, (String)((String)prop.getKey()), prop.getValue());
                }
            }
        });
        return message;
    }
}

