/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.app;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.MessageContext;
import org.eclipse.hono.cli.app.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"statistic"})
public class ReceiverStatistics {
    private static final Logger LOG_STATISTIC = LoggerFactory.getLogger(ReceiverStatistics.class);
    private static final long INTERVAL_MILLIS = 10000L;
    @Value(value="${statistic.interval}")
    protected long interval = 10000L;
    @Value(value="${statistic.autoreset}")
    protected boolean autoReset;
    private final Receiver receiver;
    private final Vertx vertx;
    private Statistic total;
    private Statistic current;

    @Autowired
    public ReceiverStatistics(Receiver receiver, Vertx vertx) {
        this.receiver = Objects.requireNonNull(receiver);
        this.vertx = Objects.requireNonNull(vertx);
    }

    @PostConstruct
    Future<CompositeFuture> start() {
        this.vertx.setPeriodic(this.interval, this::statistic);
        this.receiver.setMessageHandler((endpoint, msg) -> this.handleMessage((String)endpoint, (DownstreamMessage<? extends MessageContext>)msg));
        LOG_STATISTIC.info("Statistics [interval: {} ms, autoreset: {}]", (Object)this.interval, (Object)this.autoReset);
        return Future.succeededFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(String endpoint, DownstreamMessage<? extends MessageContext> msg) {
        String deviceId = msg.getDeviceId();
        Buffer payload = msg.getPayload();
        if (LOG_STATISTIC.isInfoEnabled()) {
            Statistic current;
            Statistic total;
            long now = System.nanoTime();
            ReceiverStatistics receiverStatistics = this;
            synchronized (receiverStatistics) {
                if (this.total == null) {
                    this.total = new Statistic(now);
                }
                total = this.total;
                if (this.current == null) {
                    this.current = new PeriodStatistic(now, this.interval);
                }
                current = this.current;
            }
            total.increment(now);
            if (!current.increment(now)) {
                if (current.isPrinting()) {
                    LOG_STATISTIC.info("statistic: total {}, last {}", (Object)total, (Object)current);
                }
                receiverStatistics = this;
                synchronized (receiverStatistics) {
                    if (this.current == current) {
                        this.current = new PeriodStatistic(now, this.interval);
                    }
                    current = this.current;
                }
                current.increment(now);
            }
        }
        LOG_STATISTIC.trace("received {} message [device: {}, content-type: {}]: {}", new Object[]{endpoint, deviceId, msg.getContentType(), payload});
        LOG_STATISTIC.trace("... with properties: {}", (Object)msg.getProperties().getPropertiesMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statistic(Long id) {
        Statistic current;
        Statistic total;
        ReceiverStatistics receiverStatistics = this;
        synchronized (receiverStatistics) {
            total = this.total;
            current = this.current;
        }
        if (total != null) {
            long now = System.nanoTime();
            if (current == null || current.finished(now)) {
                if (current == null) {
                    LOG_STATISTIC.info("statistic: total {}", (Object)total);
                } else {
                    LOG_STATISTIC.info("statistic: total {}, last {}", (Object)total, (Object)current);
                }
                ReceiverStatistics receiverStatistics2 = this;
                synchronized (receiverStatistics2) {
                    if (this.total == total && this.current == current) {
                        if (current == null) {
                            if (this.autoReset) {
                                this.total = null;
                            }
                        } else {
                            this.current = null;
                        }
                    }
                }
            }
        }
    }

    private static class PeriodStatistic
    extends Statistic {
        public final long uptimeEnd;

        private PeriodStatistic(long uptime, long interval) {
            super(uptime);
            this.uptimeEnd = uptime + TimeUnit.MILLISECONDS.toNanos(interval);
        }

        @Override
        public boolean increment(long uptime) {
            if (this.finished(uptime)) {
                return false;
            }
            return super.increment(uptime);
        }

        @Override
        public boolean finished(long uptime) {
            return uptime > this.uptimeEnd;
        }
    }

    private static class Statistic {
        public final AtomicBoolean print = new AtomicBoolean();
        public final AtomicLong counter = new AtomicLong();
        public final long startUptime;
        public volatile long lastUptime;

        private Statistic(long uptime) {
            this.startUptime = uptime;
        }

        public boolean increment(long uptime) {
            this.lastUptime = uptime;
            this.counter.incrementAndGet();
            this.print.set(false);
            return true;
        }

        public String toString() {
            long c = this.counter.get();
            long period = this.lastUptime - this.startUptime;
            if (period > 0L) {
                return String.format("%d msgs (%d msgs/s)", c, c * TimeUnit.MILLISECONDS.toNanos(1000L) / period);
            }
            return String.format("%d msgs", c);
        }

        public boolean finished(long uptime) {
            return false;
        }

        public boolean isPrinting() {
            return this.print.compareAndSet(false, true);
        }
    }
}

