/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.adapter;

import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.cli.adapter.AmqpCliClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"amqp-send"})
public class TelemetryAndEventCli
extends AmqpCliClient {
    @Value(value="${message.address}")
    private String messageAddress;
    @Value(value="${message.payload}")
    private String payload;

    @PostConstruct
    void start() {
        CompletableFuture<ProtonDelivery> messageSent = new CompletableFuture<ProtonDelivery>();
        this.sendMessage(messageSent);
        try {
            ProtonDelivery delivery = messageSent.join();
            this.printDelivery(delivery);
            System.exit(0);
        }
        catch (CompletionException e) {
            this.writer.printf("Sending message failed [reason: %s] %n", e.getCause());
            this.writer.flush();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        System.exit(1);
    }

    private void sendMessage(CompletableFuture<ProtonDelivery> messageTracker) {
        this.ctx.runOnContext(go -> this.connectToAdapter().compose(con -> {
            this.adapterConnection = con;
            return this.createSender();
        }).map(sender -> {
            Message message = ProtonHelper.message((String)this.messageAddress, (String)this.payload);
            sender.send(message, delivery -> {
                this.adapterConnection.close();
                messageTracker.complete((ProtonDelivery)delivery);
            });
            return sender;
        }).otherwise(t -> {
            messageTracker.completeExceptionally((Throwable)t);
            return null;
        }));
    }

    private void printDelivery(ProtonDelivery delivery) {
        DeliveryState state = delivery.getRemoteState();
        this.writer.printf("[Delivery State: %s] %n", state.getType()).flush();
        switch (state.getType()) {
            case Rejected: {
                Rejected rejected = (Rejected)state;
                if (rejected.getError() == null) break;
                this.writer.printf("Message rejected: [Error Condition: %s, Error Description: %s] %n", rejected.getError().getCondition(), rejected.getError().getDescription());
                this.writer.flush();
                break;
            }
        }
    }
}

