/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.adapter;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonSender;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.cli.AbstractCliClient;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AmqpCliClient
extends AbstractCliClient {
    protected PrintWriter writer = new PrintWriter(System.out);
    protected ProtonConnection adapterConnection;
    private ClientConfigProperties properties = new ClientConfigProperties();

    @Autowired(required=false)
    public void setClientConfig(ClientConfigProperties props) {
        this.properties = Objects.requireNonNull(props);
    }

    protected Future<ProtonSender> createSender() {
        if (this.adapterConnection == null || this.adapterConnection.isDisconnected()) {
            throw new IllegalStateException("connection to AMQP org.eclipse.hono.cli.app.adapter not established");
        }
        Future result = Future.future();
        ProtonSender sender = this.adapterConnection.createSender(null);
        sender.openHandler((Handler)result);
        sender.open();
        return result;
    }

    protected Future<ProtonConnection> connectToAdapter() {
        Future connectAttempt = Future.future();
        ProtonClientOptions options = new ProtonClientOptions();
        ProtonClient client = ProtonClient.create((Vertx)this.vertx);
        options.setConnectTimeout(this.properties.getConnectTimeout());
        options.setHeartbeat(this.properties.getHeartbeatInterval());
        Optional.ofNullable(this.properties.getAmqpHostname()).ifPresent(s -> options.setVirtualHost(s));
        if (!Strings.isNullOrEmpty((Object)this.properties.getUsername()) && !Strings.isNullOrEmpty((Object)this.properties.getPassword())) {
            options.addEnabledSaslMechanism("PLAIN");
            this.LOG.info("connecting to AMQP org.eclipse.hono.cli.app.adapter using SASL PLAIN [host: {}, port: {}, username: {}]", new Object[]{this.properties.getHost(), this.properties.getPort(), this.properties.getUsername()});
            client.connect(options, this.properties.getHost(), this.properties.getPort(), this.properties.getUsername(), this.properties.getPassword(), (Handler)connectAttempt);
        } else {
            if (this.properties.getKeyCertOptions() != null && this.properties.getTrustOptions() != null) {
                options.setSsl(true);
                options.setKeyCertOptions(this.properties.getKeyCertOptions());
                options.setTrustOptions(this.properties.getTrustOptions());
            }
            this.LOG.info("connecting to AMQP org.eclipse.hono.cli.app.adapter [host: {}, port: {}]", (Object)this.properties.getHost(), (Object)this.properties.getPort());
            client.connect(options, this.properties.getHost(), this.properties.getPort(), (Handler)connectAttempt);
        }
        return connectAttempt.compose(unopenedConnection -> {
            Future con = Future.future();
            unopenedConnection.openHandler((Handler)con);
            unopenedConnection.open();
            return con;
        });
    }
}

