/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt.app;

import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.eclipse.hono.adapter.AbstractProtocolAdapterApplication;
import org.eclipse.hono.adapter.AbstractProtocolAdapterBase;
import org.eclipse.hono.adapter.mqtt.MessageMapping;
import org.eclipse.hono.adapter.mqtt.MqttAdapterMetrics;
import org.eclipse.hono.adapter.mqtt.MqttContext;
import org.eclipse.hono.adapter.mqtt.MqttProtocolAdapterProperties;
import org.eclipse.hono.adapter.mqtt.impl.HttpBasedMessageMapping;
import org.eclipse.hono.adapter.mqtt.impl.VertxBasedMqttProtocolAdapter;

@ApplicationScoped
public class Application
extends AbstractProtocolAdapterApplication<MqttProtocolAdapterProperties> {
    private static final String CONTAINER_ID = "Hono MQTT Adapter";
    @Inject
    MqttAdapterMetrics metrics;

    public String getComponentName() {
        return CONTAINER_ID;
    }

    protected VertxBasedMqttProtocolAdapter adapter() {
        VertxBasedMqttProtocolAdapter adapter = new VertxBasedMqttProtocolAdapter();
        adapter.setConfig((Object)((MqttProtocolAdapterProperties)this.protocolAdapterProperties));
        adapter.setMetrics(this.metrics);
        adapter.setMessageMapping(this.messageMapping());
        this.setCollaborators((AbstractProtocolAdapterBase)adapter);
        return adapter;
    }

    private MessageMapping<MqttContext> messageMapping() {
        WebClient webClient = WebClient.create((Vertx)this.vertx);
        return new HttpBasedMessageMapping(webClient, (MqttProtocolAdapterProperties)this.protocolAdapterProperties);
    }
}

