/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import java.util.Optional;
import org.eclipse.hono.adapter.mqtt.MessageMapping;
import org.eclipse.hono.adapter.mqtt.MicrometerBasedMqttAdapterMetrics;
import org.eclipse.hono.adapter.mqtt.MqttAdapterMetrics;
import org.eclipse.hono.adapter.mqtt.MqttContext;
import org.eclipse.hono.adapter.mqtt.MqttProtocolAdapterProperties;
import org.eclipse.hono.adapter.mqtt.impl.HttpBasedMessageMapping;
import org.eclipse.hono.adapter.mqtt.impl.VertxBasedMqttProtocolAdapter;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractAdapterConfig;
import org.eclipse.hono.service.AbstractProtocolAdapterBase;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.resourcelimits.ResourceLimitChecks;
import org.springframework.beans.factory.config.ObjectFactoryCreatingFactoryBean;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class Config
extends AbstractAdapterConfig {
    private static final String CONTAINER_ID_HONO_MQTT_ADAPTER = "Hono MQTT Adapter";
    private static final String BEAN_NAME_VERTX_BASED_MQTT_PROTOCOL_ADAPTER = "vertxBasedMqttProtocolAdapter";

    @Bean(name={"vertxBasedMqttProtocolAdapter"})
    @Scope(value="prototype")
    public VertxBasedMqttProtocolAdapter vertxBasedMqttProtocolAdapter(SendMessageSampler.Factory samplerFactory, MqttAdapterMetrics metrics, Optional<ResourceLimitChecks> resourceLimitChecks) {
        VertxBasedMqttProtocolAdapter adapter = new VertxBasedMqttProtocolAdapter();
        this.setCollaborators((AbstractProtocolAdapterBase)adapter, (ProtocolAdapterProperties)this.adapterProperties(), samplerFactory, resourceLimitChecks);
        adapter.setConfig((ProtocolAdapterProperties)this.adapterProperties());
        adapter.setMetrics(metrics);
        adapter.setMessageMapping(this.messageMapping());
        return adapter;
    }

    protected String getAdapterName() {
        return CONTAINER_ID_HONO_MQTT_ADAPTER;
    }

    @Bean
    @ConfigurationProperties(prefix="hono.mqtt")
    public MqttProtocolAdapterProperties adapterProperties() {
        return new MqttProtocolAdapterProperties();
    }

    @Bean
    MqttAdapterMetrics metrics(MeterRegistry registry, Vertx vertx) {
        return new MicrometerBasedMqttAdapterMetrics(registry, vertx);
    }

    @Bean
    public MeterRegistryCustomizer<MeterRegistry> commonTags() {
        return r -> r.config().commonTags((Iterable)MetricsTags.forProtocolAdapter((String)"hono-mqtt"));
    }

    @Bean
    public ObjectFactoryCreatingFactoryBean serviceFactory() {
        ObjectFactoryCreatingFactoryBean factory = new ObjectFactoryCreatingFactoryBean();
        factory.setTargetBeanName(BEAN_NAME_VERTX_BASED_MQTT_PROTOCOL_ADAPTER);
        return factory;
    }

    @Bean
    public MessageMapping<MqttContext> messageMapping() {
        WebClient webClient = WebClient.create((Vertx)this.vertx());
        return new HttpBasedMessageMapping(webClient, this.adapterProperties());
    }
}

