/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.opentracing.Span;
import io.vertx.mqtt.MqttEndpoint;
import java.util.Objects;
import java.util.OptionalInt;
import org.eclipse.hono.util.MapBasedExecutionContext;

public final class MqttConnectContext
extends MapBasedExecutionContext {
    private final MqttEndpoint deviceEndpoint;
    private OptionalInt traceSamplingPriority = OptionalInt.empty();

    private MqttConnectContext(Span span, MqttEndpoint deviceEndpoint) {
        super(span);
        this.deviceEndpoint = Objects.requireNonNull(deviceEndpoint);
    }

    public static MqttConnectContext fromConnectPacket(MqttEndpoint endpoint, Span span) {
        return new MqttConnectContext(span, endpoint);
    }

    public MqttEndpoint deviceEndpoint() {
        return this.deviceEndpoint;
    }

    public OptionalInt getTraceSamplingPriority() {
        return this.traceSamplingPriority;
    }

    public void setTraceSamplingPriority(OptionalInt traceSamplingPriority) {
        this.traceSamplingPriority = Objects.requireNonNull(traceSamplingPriority);
    }
}

