/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.jsonwebtoken.MalformedJwtException;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.mqtt.MqttAuth;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.jwt.CredentialsParser;
import org.eclipse.hono.adapter.auth.device.jwt.DefaultJwsValidator;
import org.eclipse.hono.adapter.mqtt.MqttConnectContext;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;

public class JwtAuthHandler
extends ExecutionContextAuthHandler<MqttConnectContext>
implements CredentialsParser {
    public JwtAuthHandler(DeviceCredentialsAuthProvider<?> authProvider) {
        this(authProvider, null);
    }

    protected JwtAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, PreCredentialsValidationHandler<MqttConnectContext> preCredentialsValidationHandler) {
        super(authProvider, preCredentialsValidationHandler);
    }

    public Future<JsonObject> parseCredentials(MqttConnectContext context) {
        Objects.requireNonNull(context);
        MqttAuth auth = context.deviceEndpoint().auth();
        if (auth == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(401, "CONNECT packet does not contain auth info"));
        }
        if (auth.getPassword() == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(401, "CONNECT packet does not contain password"));
        }
        Promise result = Promise.promise();
        try {
            JsonObject claims = DefaultJwsValidator.getJwtClaims((String)auth.getPassword());
            JsonObject credentials = Optional.ofNullable(claims.getValue("aud")).map(v -> {
                if (v instanceof String) {
                    String stringValue = (String)v;
                    return JsonArray.of((Object[])new Object[]{stringValue});
                }
                if (v instanceof JsonArray) {
                    JsonArray array = (JsonArray)v;
                    return array;
                }
                return JsonArray.of((Object[])new Object[0]);
            }).filter(aud -> aud.contains((Object)"hono-adapter")).map(aud -> this.parseCredentialsFromClaims(claims)).orElseGet(() -> this.parseCredentialsFromString(context.deviceEndpoint().clientIdentifier()));
            credentials.put("password", (Object)auth.getPassword());
            result.complete((Object)credentials);
        }
        catch (MalformedJwtException e) {
            result.fail((Throwable)new ClientErrorException(401, (Throwable)e));
        }
        catch (ServiceInvocationException e) {
            result.fail((Throwable)e);
        }
        return result.future();
    }

    public JsonObject parseCredentialsFromString(String clientId) {
        Objects.requireNonNull(clientId);
        String[] clientIdSplit = clientId.split("/");
        int splitLength = clientIdSplit.length;
        if (splitLength < 3) {
            throw new ClientErrorException(401, "MQTT client identifier must contain tenant and device ID");
        }
        String tenant = clientIdSplit[splitLength - 3];
        String authId = clientIdSplit[splitLength - 1];
        return new JsonObject().put("tenant-id", (Object)tenant).put("auth-id", (Object)authId).put("iss", (Object)authId);
    }
}

