/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.mqtt.MqttTopicSubscription;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.mqtt.AbstractSubscription;
import org.eclipse.hono.adapter.mqtt.MqttContext;
import org.eclipse.hono.adapter.mqtt.Subscription;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorSubscription
extends AbstractSubscription {
    public static final String ERROR_ENDPOINT = "error";
    public static final String ERROR_ENDPOINT_SHORT = "e";
    public static final String UNKNOWN_ENDPOINT = "unknown";
    public static final String COMMAND_RESPONSE_ENDPOINT = "command-response";
    public static final String COMMAND_RESPONSE_ENDPOINT_SHORT = "c-s";
    private static final Logger LOG = LoggerFactory.getLogger(ErrorSubscription.class);
    private final Subscription.Key key = ErrorSubscription.getKey(this.getTenant(), this.getDeviceId());

    private ErrorSubscription(ResourceIdentifier topicResource, Device authenticatedDevice, MqttQoS qos) {
        super(topicResource, qos, authenticatedDevice);
    }

    public static ErrorSubscription fromTopic(MqttTopicSubscription mqttTopicSub, Device authenticatedDevice) {
        Objects.requireNonNull(mqttTopicSub);
        return ErrorSubscription.fromTopic(mqttTopicSub.topicName(), mqttTopicSub.qualityOfService(), authenticatedDevice);
    }

    public static ErrorSubscription fromTopic(String topic, MqttQoS qos, Device authenticatedDevice) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(qos);
        try {
            ResourceIdentifier topicResource = ErrorSubscription.validateTopic(topic);
            return new ErrorSubscription(topicResource, authenticatedDevice, qos);
        }
        catch (IllegalArgumentException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    private static ResourceIdentifier validateTopic(String topic) {
        Objects.requireNonNull(topic);
        if (!ResourceIdentifier.isValid((String)topic)) {
            throw new IllegalArgumentException("topic filter or its first segment must not be empty");
        }
        ResourceIdentifier resource = ResourceIdentifier.fromString((String)topic);
        if (resource.length() != 4 || !"#".equals(resource.elementAt(resource.length() - 1))) {
            throw new IllegalArgumentException("invalid topic filter: must have 4 segments and end with '#'");
        }
        if (!ErrorSubscription.isErrorEndpoint(resource.getEndpoint())) {
            throw new IllegalArgumentException("the endpoint needs to be 'error' or 'e'");
        }
        return resource;
    }

    private static boolean isErrorEndpoint(String endpoint) {
        return ERROR_ENDPOINT.equals(endpoint) || ERROR_ENDPOINT_SHORT.equals(endpoint);
    }

    public static boolean hasErrorEndpointPrefix(String topic) {
        return topic != null && (topic.startsWith("error/") || topic.startsWith("e/"));
    }

    public static Subscription.Key getKey(String topic, Device authenticatedDevice) {
        Objects.requireNonNull(topic);
        try {
            ResourceIdentifier topicResource = ErrorSubscription.validateTopic(topic);
            return new ErrorSubscription(topicResource, authenticatedDevice, MqttQoS.AT_MOST_ONCE).getKey();
        }
        catch (IllegalArgumentException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    public static Subscription.Key getKey(String tenantId, String deviceId) {
        return new AbstractSubscription.DefaultKey(tenantId, deviceId, AbstractSubscription.DefaultKey.Type.ERROR);
    }

    @Override
    public Subscription.Key getKey() {
        return this.key;
    }

    public String getErrorPublishTopic(MqttContext context, int errorCode) {
        Objects.requireNonNull(context);
        String contextDeviceId = context.deviceId();
        String contextEndpoint = Optional.ofNullable(context.topic()).map(ResourceIdentifier::getEndpoint).orElse("");
        return this.getErrorPublishTopic(contextEndpoint, contextDeviceId, context.correlationId(), errorCode);
    }

    public String getErrorPublishTopic(String messageEndpoint, String deviceId, String correlationId, int errorCode) {
        String topicTenantId;
        String string = topicTenantId = this.containsTenantId() ? this.getTenant() : "";
        String topicDeviceId = !Strings.isNullOrEmpty((Object)deviceId) && !deviceId.equals(this.getDeviceId()) ? deviceId : (this.containsDeviceId() ? this.getDeviceId() : "");
        return String.format("%s/%s/%s/%s/%s/%s", this.getEndpoint(), topicTenantId, topicDeviceId, this.getSanitizedMessageEndpoint(messageEndpoint), Strings.isNullOrEmpty((Object)correlationId) ? "-1" : correlationId, errorCode);
    }

    private String getSanitizedMessageEndpoint(String messageEndpoint) {
        if (messageEndpoint != null) {
            switch (messageEndpoint) {
                case "telemetry": 
                case "t": 
                case "event": 
                case "e": {
                    return messageEndpoint;
                }
                case "command": {
                    return COMMAND_RESPONSE_ENDPOINT;
                }
                case "c": {
                    return COMMAND_RESPONSE_ENDPOINT_SHORT;
                }
            }
            return UNKNOWN_ENDPOINT;
        }
        return UNKNOWN_ENDPOINT;
    }
}

