/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.hono.adapter.mqtt.Subscription;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public abstract class AbstractSubscription
implements Subscription {
    private static final String LOG_FIELD_TOPIC_FILTER = "filter";
    private final String endpoint;
    private final String tenant;
    private final String deviceId;
    private final String authenticatedDeviceId;
    private final String topic;
    private final boolean authenticated;
    private final boolean containsTenantId;
    private final boolean containsSpecificDeviceId;
    private final boolean containsWildcardDeviceId;
    private final MqttQoS qos;

    protected AbstractSubscription(ResourceIdentifier topicResource, MqttQoS qos, Device authenticatedDevice) {
        Objects.requireNonNull(topicResource);
        Objects.requireNonNull(qos);
        if ("+".equals(topicResource.getTenantId())) {
            throw new IllegalArgumentException("topic filter must not contain '+' wildcard for tenant ID");
        }
        this.topic = topicResource.toString();
        this.qos = qos;
        this.endpoint = topicResource.getEndpoint();
        String resourceTenant = topicResource.getTenantId();
        this.containsTenantId = !Strings.isNullOrEmpty((Object)resourceTenant);
        this.containsWildcardDeviceId = "+".equals(topicResource.getResourceId());
        String resourceDeviceId = this.containsWildcardDeviceId ? null : topicResource.getResourceId();
        this.containsSpecificDeviceId = !Strings.isNullOrEmpty((Object)resourceDeviceId);
        boolean bl = this.authenticated = authenticatedDevice != null;
        if (authenticatedDevice != null) {
            if (resourceTenant != null && !authenticatedDevice.getTenantId().equals(resourceTenant)) {
                throw new IllegalArgumentException("tenant in topic filter does not match authenticated device");
            }
            this.tenant = authenticatedDevice.getTenantId();
            this.authenticatedDeviceId = authenticatedDevice.getDeviceId();
            this.deviceId = Strings.isNullOrEmpty((Object)resourceDeviceId) ? authenticatedDevice.getDeviceId() : resourceDeviceId;
        } else {
            if (Strings.isNullOrEmpty((Object)resourceTenant)) {
                throw new IllegalArgumentException("for unauthenticated devices the tenant needs to be given in the subscription");
            }
            if (Strings.isNullOrEmpty((Object)resourceDeviceId)) {
                throw new IllegalArgumentException("for unauthenticated devices the device-id needs to be given in the subscription");
            }
            this.tenant = resourceTenant;
            this.authenticatedDeviceId = null;
            this.deviceId = resourceDeviceId;
        }
    }

    @Override
    public final String getTenant() {
        return this.tenant;
    }

    @Override
    public final String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public final String getAuthenticatedDeviceId() {
        return this.authenticatedDeviceId;
    }

    @Override
    public final String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public final MqttQoS getQos() {
        return this.qos;
    }

    @Override
    public final String getTopic() {
        return this.topic;
    }

    @Override
    public final boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public final boolean isGatewaySubscriptionForSpecificDevice() {
        return this.authenticatedDeviceId != null && !this.authenticatedDeviceId.equals(this.deviceId);
    }

    @Override
    public final boolean isGatewaySubscriptionForAllDevices() {
        return this.authenticatedDeviceId != null && this.containsWildcardDeviceId;
    }

    @Override
    public boolean containsTenantId() {
        return this.containsTenantId;
    }

    @Override
    public boolean containsDeviceId() {
        return this.containsSpecificDeviceId;
    }

    @Override
    public final void logSubscribeSuccess(Span span) {
        Objects.requireNonNull(span);
        HashMap<String, String> items = new HashMap<String, String>(4);
        items.put("event", "accepting subscription");
        items.put(LOG_FIELD_TOPIC_FILTER, this.getTopic());
        items.put("requested QoS", (String)this.getQos());
        items.put("granted QoS", (String)this.getQos());
        span.log(items);
    }

    @Override
    public final void logSubscribeFailure(Span span, Throwable error) {
        Objects.requireNonNull(span);
        Objects.requireNonNull(error);
        HashMap<String, Object> items = new HashMap<String, Object>(4);
        items.put("event", Tags.ERROR.getKey());
        items.put(LOG_FIELD_TOPIC_FILTER, this.getTopic());
        items.put("requested QoS", this.getQos());
        items.put("message", "rejecting subscription: " + error.getMessage());
        TracingHelper.logError((Span)span, items);
    }

    @Override
    public final void logUnsubscribe(Span span) {
        Objects.requireNonNull(span);
        HashMap<String, String> items = new HashMap<String, String>(2);
        items.put("event", "removing subscription");
        items.put(LOG_FIELD_TOPIC_FILTER, this.getTopic());
        span.log(items);
    }

    static final class DefaultKey
    implements Subscription.Key {
        private final String tenant;
        private final String deviceId;
        private final Type type;

        DefaultKey(String tenant, String deviceId, Type type) {
            this.tenant = Objects.requireNonNull(tenant);
            this.deviceId = Objects.requireNonNull(deviceId);
            this.type = Objects.requireNonNull(type);
        }

        @Override
        public String getTenant() {
            return this.tenant;
        }

        @Override
        public String getDeviceId() {
            return this.deviceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultKey that = (DefaultKey)o;
            return this.tenant.equals(that.tenant) && this.deviceId.equals(that.deviceId) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.tenant, this.deviceId, this.type});
        }

        static enum Type {
            COMMAND,
            ERROR;

        }
    }
}

