/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.SubjectDnCredentials;
import org.eclipse.hono.adapter.auth.device.X509Authentication;
import org.eclipse.hono.adapter.mqtt.MqttConnectContext;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.SniExtensionHelper;

public class X509AuthHandler
extends ExecutionContextAuthHandler<MqttConnectContext> {
    private static final ClientErrorException UNAUTHORIZED = new ClientErrorException(401);
    private final X509Authentication auth;

    public X509AuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider) {
        this(clientAuth, authProvider, null);
    }

    public X509AuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider, PreCredentialsValidationHandler<MqttConnectContext> preCredentialsValidationHandler) {
        super(authProvider, preCredentialsValidationHandler);
        this.auth = Objects.requireNonNull(clientAuth);
    }

    public Future<JsonObject> parseCredentials(MqttConnectContext context) {
        Objects.requireNonNull(context);
        if (context.deviceEndpoint() == null) {
            throw new IllegalArgumentException("no device endpoint");
        }
        if (context.deviceEndpoint().isSsl()) {
            try {
                Certificate[] path = context.deviceEndpoint().sslSession().getPeerCertificates();
                List requestedHostNames = SniExtensionHelper.getHostNames((SSLSession)context.deviceEndpoint().sslSession());
                SpanContext currentSpan = context.getTracingContext();
                return this.auth.validateClientCertificate(path, requestedHostNames, currentSpan).map(authInfo -> authInfo.put("client-id", (Object)context.deviceEndpoint().clientIdentifier()));
            }
            catch (SSLPeerUnverifiedException e) {
                this.log.debug("could not retrieve client certificate from device endpoint: {}", (Object)e.getMessage());
                return Future.failedFuture((Throwable)UNAUTHORIZED);
            }
        }
        return Future.failedFuture((Throwable)UNAUTHORIZED);
    }
}

