/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.mqtt.MqttAuth;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.UsernamePasswordCredentials;
import org.eclipse.hono.adapter.mqtt.MqttConnectContext;
import org.eclipse.hono.client.ClientErrorException;

public class ConnectPacketAuthHandler
extends ExecutionContextAuthHandler<MqttConnectContext> {
    public ConnectPacketAuthHandler(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> authProvider) {
        this(authProvider, null);
    }

    public ConnectPacketAuthHandler(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> authProvider, PreCredentialsValidationHandler<MqttConnectContext> preCredentialsValidationHandler) {
        super(authProvider, preCredentialsValidationHandler);
    }

    public Future<JsonObject> parseCredentials(MqttConnectContext context) {
        Objects.requireNonNull(context);
        if (context.deviceEndpoint() == null) {
            throw new IllegalArgumentException("no device endpoint");
        }
        Promise result = Promise.promise();
        MqttAuth auth = context.deviceEndpoint().auth();
        if (auth == null) {
            result.fail((Throwable)new ClientErrorException(401, "device did not provide credentials in CONNECT packet"));
        } else if (auth.getUsername() == null || auth.getPassword() == null) {
            result.fail((Throwable)new ClientErrorException(401, "device provided malformed credentials in CONNECT packet"));
        } else {
            JsonObject credentialsJSON = new JsonObject().put("username", (Object)auth.getUsername()).put("password", (Object)auth.getPassword()).put("client-id", (Object)context.deviceEndpoint().clientIdentifier());
            result.complete((Object)credentialsJSON);
        }
        return result.future();
    }
}

