/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.mqtt.MqttTopicSubscription;
import java.util.Objects;
import org.eclipse.hono.adapter.mqtt.AbstractSubscription;
import org.eclipse.hono.adapter.mqtt.Subscription;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.util.CommandConstants;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandSubscription
extends AbstractSubscription {
    private static final Logger LOG = LoggerFactory.getLogger(CommandSubscription.class);
    private static final String ERROR_MSG_FILTER_FORMAT = String.format("topic filter does not match pattern: %s|%s/[tenant-id]/[device-id|+]/%s|%s/#", "command", "c", "req", "q");
    private static final String ERROR_MSG_ENDPOINT_NAME = String.format("the endpoint needs to be '%s' or '%s'", "command", "c");
    private static final String ERROR_MSG_REQUEST_SEGMENT_NAME = String.format("the request part needs to be '%s' or '%s'", "req", "q");
    private final String req;
    private final Subscription.Key key;

    private CommandSubscription(ResourceIdentifier topicResource, Device authenticatedDevice, MqttQoS qos) {
        super(topicResource, qos, authenticatedDevice);
        this.req = topicResource.elementAt(3);
        this.key = new AbstractSubscription.DefaultKey(this.getTenant(), this.getDeviceId(), AbstractSubscription.DefaultKey.Type.COMMAND);
    }

    public static CommandSubscription fromTopic(MqttTopicSubscription mqttTopicSub, Device authenticatedDevice) {
        Objects.requireNonNull(mqttTopicSub);
        return CommandSubscription.fromTopic(mqttTopicSub.topicName(), mqttTopicSub.qualityOfService(), authenticatedDevice);
    }

    public static CommandSubscription fromTopic(String topic, MqttQoS qos, Device authenticatedDevice) {
        Objects.requireNonNull(topic);
        Objects.requireNonNull(qos);
        try {
            ResourceIdentifier topicResource = CommandSubscription.validateTopic(topic);
            return new CommandSubscription(topicResource, authenticatedDevice, qos);
        }
        catch (IllegalArgumentException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    private static ResourceIdentifier validateTopic(String topic) {
        Objects.requireNonNull(topic);
        if (!ResourceIdentifier.isValid((String)topic)) {
            throw new IllegalArgumentException("topic filter or its first segment must not be empty");
        }
        ResourceIdentifier resource = ResourceIdentifier.fromString((String)topic);
        if (resource.length() != 5 || !"#".equals(resource.elementAt(4))) {
            throw new IllegalArgumentException(ERROR_MSG_FILTER_FORMAT);
        }
        if (!CommandConstants.isCommandEndpoint((String)resource.getEndpoint())) {
            throw new IllegalArgumentException(ERROR_MSG_ENDPOINT_NAME);
        }
        if (!"req".equals(resource.elementAt(3)) && !"q".equals(resource.elementAt(3))) {
            throw new IllegalArgumentException(ERROR_MSG_REQUEST_SEGMENT_NAME);
        }
        return resource;
    }

    public static boolean hasCommandEndpointPrefix(String topic) {
        return topic != null && (topic.startsWith("command/") || topic.startsWith("c/"));
    }

    public static Subscription.Key getKey(String topic, Device authenticatedDevice) {
        Objects.requireNonNull(topic);
        try {
            ResourceIdentifier topicResource = CommandSubscription.validateTopic(topic);
            return new CommandSubscription(topicResource, authenticatedDevice, MqttQoS.AT_MOST_ONCE).getKey();
        }
        catch (IllegalArgumentException e) {
            LOG.debug(e.getMessage());
            return null;
        }
    }

    @Override
    public Subscription.Key getKey() {
        return this.key;
    }

    public String getRequestPart() {
        return this.req;
    }

    public String getCommandPublishTopic(Command command) {
        String topicTenantId;
        Objects.requireNonNull(command);
        String string = topicTenantId = this.containsTenantId() ? this.getTenant() : "";
        String topicDeviceId = command.isTargetedAtGateway() ? command.getDeviceId() : (this.containsDeviceId() ? this.getDeviceId() : "");
        String topicCommandRequestId = command.isOneWay() ? "" : command.getRequestId();
        return String.format("%s/%s/%s/%s/%s/%s", this.getEndpoint(), topicTenantId, topicDeviceId, this.getRequestPart(), topicCommandRequestId, command.getName());
    }
}

