/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import com.google.common.io.BaseEncoding;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.JsonBasedLoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

abstract class ActilityBaseProvider
extends JsonBasedLoraProvider {
    protected static final String FIELD_ACTILITY_CHANNEL = "Channel";
    protected static final String FIELD_ACTILITY_FPORT = "FPort";
    protected static final String FIELD_ACTILITY_FRAME_COUNT_UPLINK = "FCntUp";
    protected static final String FIELD_ACTILITY_LATITUTDE = "LrrLAT";
    protected static final String FIELD_ACTILITY_LONGITUDE = "LrrLON";
    protected static final String FIELD_ACTILITY_LRR = "Lrr";
    protected static final String FIELD_ACTILITY_LRR_ID = "Lrrid";
    protected static final String FIELD_ACTILITY_LRR_RSSI = "LrrRSSI";
    protected static final String FIELD_ACTILITY_LRR_SNR = "LrrSNR";
    protected static final String FIELD_ACTILITY_LRRS = "Lrrs";
    protected static final String FIELD_ACTILITY_SPREADING_FACTOR = "SpFact";
    private static final String FIELD_ACTILITY_DEVICE_EUI = "DevEUI";
    private static final String FIELD_ACTILITY_ROOT_OBJECT = "DevEUI_uplink";
    private static final String FIELD_ACTILITY_PAYLOAD = "payload_hex";

    ActilityBaseProvider() {
    }

    protected Optional<JsonObject> getRootObject(JsonObject loraMessage) {
        return LoraUtils.getChildObject(loraMessage, FIELD_ACTILITY_ROOT_OBJECT, JsonObject.class);
    }

    @Override
    protected byte[] getDevEui(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return this.getRootObject(loraMessage).map(root -> root.getValue(FIELD_ACTILITY_DEVICE_EUI)).filter(String.class::isInstance).map(String.class::cast).map(LoraUtils::convertFromHexToBytes).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain String valued device EUI property"));
    }

    @Override
    protected Buffer getPayload(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return this.getRootObject(loraMessage).map(root -> root.getValue(FIELD_ACTILITY_PAYLOAD)).filter(String.class::isInstance).map(String.class::cast).map(s -> Buffer.buffer((byte[])BaseEncoding.base16().decode((CharSequence)s.toUpperCase()))).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain String valued payload property"));
    }

    @Override
    protected LoraMessageType getMessageType(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return this.getRootObject(loraMessage).map(root -> LoraMessageType.UPLINK).orElse(LoraMessageType.UNKNOWN);
    }

    protected Double getFrequency(String logicalChannelId) {
        switch (logicalChannelId) {
            case "LC1": {
                return 868.1;
            }
            case "LC2": {
                return 868.3;
            }
            case "LC3": {
                return 868.5;
            }
            case "RX2": {
                return 869.525;
            }
        }
        return null;
    }

    @Override
    protected LoraMetaData getMetaData(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return this.getRootObject(loraMessage).map(this::extractMetaData).orElse(null);
    }

    protected abstract LoraMetaData extractMetaData(JsonObject var1);
}

