/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import com.google.common.io.BaseEncoding;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.JsonBasedLoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

@ApplicationScoped
public class LiveObjectsProvider
extends JsonBasedLoraProvider {
    private static final String FIELD_LIVE_OBJECTS_ALTITUDE = "alt";
    private static final String FIELD_LIVE_OBJECTS_DEV_EUI = "devEUI";
    private static final String FIELD_LIVE_OBJECTS_FUNCTION_PORT = "port";
    private static final String FIELD_LIVE_OBJECTS_FRAME_COUNT = "fcnt";
    private static final String FIELD_LIVE_OBJECTS_FREQUENCY = "frequency";
    private static final String FIELD_LIVE_OBJECTS_LATITUDE = "lat";
    private static final String FIELD_LIVE_OBJECTS_LOCATION = "location";
    private static final String FIELD_LIVE_OBJECTS_LONGITUDE = "lon";
    private static final String FIELD_LIVE_OBJECTS_LORA = "lora";
    private static final String FIELD_LIVE_OBJECTS_MESSAGE_TYPE = "messageType";
    private static final String FIELD_LIVE_OBJECTS_METADATA = "metadata";
    private static final String FIELD_LIVE_OBJECTS_NETWORK = "network";
    private static final String FIELD_LIVE_OBJECTS_PAYLOAD = "payload";
    private static final String FIELD_LIVE_OBJECTS_SPREADING_FACTOR = "sf";
    private static final String FIELD_LIVE_OBJECTS_VALUE = "value";
    private static final String LIVE_OBJECTS_CONFIRMED_DATA_UP = "CONFIRMED_DATA_UP";
    private static final String LIVE_OBJECTS_UNCONFIRMED_DATA_UP = "UNCONFIRMED_DATA_UP";

    @Override
    public String getProviderName() {
        return "liveObjects";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/liveObjects");
    }

    @Override
    protected byte[] getDevEui(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return this.getLoraObject(loraMessage).flatMap(lora -> LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_DEV_EUI, String.class)).map(LoraUtils::convertFromHexToBytes).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain device ID property"));
    }

    private Optional<JsonObject> getLoraObject(JsonObject loraMessage) {
        return LoraUtils.getChildObject(loraMessage, FIELD_LIVE_OBJECTS_METADATA, JsonObject.class).flatMap(metadata -> LoraUtils.getChildObject(metadata, FIELD_LIVE_OBJECTS_NETWORK, JsonObject.class)).flatMap(network -> LoraUtils.getChildObject(network, FIELD_LIVE_OBJECTS_LORA, JsonObject.class));
    }

    @Override
    protected Buffer getPayload(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, FIELD_LIVE_OBJECTS_VALUE, JsonObject.class).flatMap(value -> LoraUtils.getChildObject(value, FIELD_LIVE_OBJECTS_PAYLOAD, String.class)).map(s -> Buffer.buffer((byte[])BaseEncoding.base16().decode((CharSequence)s.toUpperCase()))).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain HEX encoded payload property"));
    }

    @Override
    protected LoraMessageType getMessageType(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return this.getLoraObject(loraMessage).flatMap(lora -> LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_MESSAGE_TYPE, String.class)).map(messageType -> {
            switch (messageType) {
                case "CONFIRMED_DATA_UP": 
                case "UNCONFIRMED_DATA_UP": {
                    return LoraMessageType.UPLINK;
                }
            }
            return LoraMessageType.UNKNOWN;
        }).orElse(LoraMessageType.UNKNOWN);
    }

    @Override
    protected LoraMetaData getMetaData(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        LoraMetaData data = new LoraMetaData();
        Optional<JsonObject> loraObject = this.getLoraObject(loraMessage);
        loraObject.ifPresent(lora -> {
            LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_FUNCTION_PORT, Integer.class).ifPresent(data::setFunctionPort);
            LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_FRAME_COUNT, Integer.class).ifPresent(data::setFrameCount);
            LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_FREQUENCY, Double.class).ifPresent(data::setFrequency);
            LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_SPREADING_FACTOR, Integer.class).ifPresent(data::setSpreadingFactor);
            LoraUtils.getChildObject(lora, FIELD_LIVE_OBJECTS_LOCATION, JsonObject.class).ifPresent(location -> Optional.ofNullable(LoraUtils.newLocation(LoraUtils.getChildObject(location, FIELD_LIVE_OBJECTS_LONGITUDE, Double.class), LoraUtils.getChildObject(location, FIELD_LIVE_OBJECTS_LATITUDE, Double.class), LoraUtils.getChildObject(location, FIELD_LIVE_OBJECTS_ALTITUDE, Double.class))).ifPresent(data::setLocation));
        });
        return data;
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return Map.of(HttpHeaders.CONTENT_TYPE.toString(), "application/json", HttpHeaders.ACCEPT.toString(), "application/json");
    }
}

