/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.Location;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class LoraMetaData {
    @JsonProperty(value="bandwidth")
    private Integer bandwidth;
    @JsonProperty(value="function_port")
    private Integer functionPort;
    @JsonProperty(value="frame_count")
    private Integer frameCount;
    @JsonProperty(value="frequency")
    private Double frequency;
    @JsonProperty(value="data_rate")
    private Integer dataRate;
    @JsonProperty(value="data_rate_id")
    private String dataRateIdentifier;
    @JsonProperty(value="coding_rate")
    private String codingRate;
    @JsonProperty(value="adr_enabled")
    private Boolean adaptiveDataRateEnabled;
    @JsonProperty(value="spreading_factor")
    private Integer spreadingFactor;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="gateways")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<GatewayInfo> gatewayInfo = new LinkedList<GatewayInfo>();

    public Integer getBandwidth() {
        return this.bandwidth;
    }

    public LoraMetaData setBandwidth(Integer bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public Integer getFunctionPort() {
        return this.functionPort;
    }

    public LoraMetaData setFunctionPort(Integer functionPort) {
        this.functionPort = functionPort;
        return this;
    }

    public Integer getFrameCount() {
        return this.frameCount;
    }

    public LoraMetaData setFrameCount(Integer frameCount) {
        this.frameCount = frameCount;
        return this;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public LoraMetaData setFrequency(Double frequency) {
        if (frequency < 0.0) {
            throw new IllegalArgumentException("frequency must be positive");
        }
        this.frequency = frequency;
        return this;
    }

    public String getCodingRate() {
        return this.codingRate;
    }

    public LoraMetaData setCodingRate(String codingRate) {
        this.codingRate = codingRate;
        return this;
    }

    public Boolean getAdaptiveDataRateEnabled() {
        return this.adaptiveDataRateEnabled;
    }

    public LoraMetaData setAdaptiveDataRateEnabled(Boolean flag) {
        this.adaptiveDataRateEnabled = flag;
        return this;
    }

    public Integer getSpreadingFactor() {
        return this.spreadingFactor;
    }

    public LoraMetaData setSpreadingFactor(Integer spreadingFactor) {
        if (spreadingFactor != null && (spreadingFactor < 7 || spreadingFactor > 12)) {
            throw new IllegalArgumentException("spreading factor must be > 6 and < 13");
        }
        this.spreadingFactor = spreadingFactor;
        return this;
    }

    public Location getLocation() {
        return this.location;
    }

    public LoraMetaData setLocation(Location location) {
        this.location = location;
        return this;
    }

    @JsonIgnore
    public LoraMetaData addGatewayInfo(GatewayInfo gwInfo) {
        Objects.requireNonNull(gwInfo);
        this.gatewayInfo.add(gwInfo);
        return this;
    }

    public List<GatewayInfo> getGatewayInfo() {
        return Collections.unmodifiableList(this.gatewayInfo);
    }
}

