/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.http;

import io.jsonwebtoken.MalformedJwtException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.util.Objects;
import org.eclipse.hono.adapter.HttpContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.jwt.CredentialsParser;
import org.eclipse.hono.adapter.auth.device.jwt.DefaultJwsValidator;
import org.eclipse.hono.adapter.auth.device.jwt.JwtCredentials;
import org.eclipse.hono.adapter.http.AuthHandlerTools;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.util.ExecutionContext;

public final class JwtAuthHandler
extends HTTPAuthorizationHandler<AuthenticationProvider>
implements CredentialsParser {
    private final PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler;

    public JwtAuthHandler(DeviceCredentialsAuthProvider<JwtCredentials> authProvider, String realm) {
        this(authProvider, realm, null);
    }

    public JwtAuthHandler(DeviceCredentialsAuthProvider<JwtCredentials> authProvider, String realm, PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler) {
        super(authProvider, HTTPAuthorizationHandler.Type.BEARER, realm);
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
    }

    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        this.parseAuthorization(context, parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            String token = (String)parseAuthorization.result();
            try {
                JsonObject claims = DefaultJwsValidator.getJwtClaims((String)token);
                final JsonObject credentials = Objects.equals(claims.getString("aud"), "hono-adapter") ? this.parseCredentialsFromClaims(claims) : this.parseCredentialsFromString(context.request().uri());
                credentials.put("password", (Object)token);
                ExecutionContextAuthHandler<HttpContext> authHandler = new ExecutionContextAuthHandler<HttpContext>((DeviceCredentialsAuthProvider)this.authProvider, this.preCredentialsValidationHandler){

                    public Future<JsonObject> parseCredentials(HttpContext context) {
                        return Future.succeededFuture((Object)credentials);
                    }
                };
                authHandler.authenticateDevice((ExecutionContext)HttpContext.from((RoutingContext)context)).map(User.class::cast).onComplete(handler);
            }
            catch (MalformedJwtException e) {
                handler.handle((Object)Future.failedFuture((Throwable)new HttpException(400, "Malformed token")));
            }
            catch (ServiceInvocationException e) {
                handler.handle((Object)Future.failedFuture((Throwable)new HttpException(400, (Throwable)e)));
            }
        });
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (ctx.response().ended()) {
            return;
        }
        AuthHandlerTools.processException(ctx, exception, null);
    }

    public JsonObject parseCredentialsFromString(String uri) {
        Objects.requireNonNull(uri);
        String[] uriSplit = uri.split("/");
        if (uriSplit.length < 4) {
            throw new ClientErrorException(401, "URI must contain tenant and device ID");
        }
        String tenant = uriSplit[2];
        String authId = uriSplit[3];
        return new JsonObject().put("tenant-id", (Object)tenant).put("auth-id", (Object)authId).put("iss", (Object)authId);
    }
}

